package com.valor.mfc.vms.meta.model.database.ddo.person;

import com.google.common.base.Objects;

import common.base.tools.type.DdoKeyTools;
import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.common.database.model.AbstractLMI;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/12/14.
 */
@MappedSuperclass
public class AbstractPersonFilmography extends AbstractLMI {
    @Id
    @Column(name = "person_id")
    public long personId;

    @Id
    @Column(name = "media_id")
    public long mediaId;

    @Column(name = "video_type")
    protected EVideoType mediaType =EVideoType.UNKNOWN;

    public long getPersonId() {
        return personId;
    }

    public void setPersonId(long personId) {
        this.personId = personId;
    }

    public long getMediaId() {
        return mediaId;
    }

    public void setMediaId(long mediaId) {
        this.mediaId = mediaId;
    }

    public EVideoType getMediaType() {
        return mediaType;
    }

    public void setMediaType(EVideoType mediaType) {
        this.mediaType = mediaType;
    }


    @Override
    public String valueKey() {
        return DdoKeyTools.key(personId, mediaId);
    }

    @Override
    public boolean valueEquals(Object o) {
        return equals(o);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PersonFilmography that = (PersonFilmography) o;

        return Objects.equal(this.personId, that.personId) &&
                Objects.equal(this.mediaId, that.mediaId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(personId, mediaId);
    }

}
