package com.valor.mfc.vms.meta.model.service;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import common.base.tools.stat.StatTools;
import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.common.tools.meta.LanguageTools;
import com.valor.mfc.vms.common.tools.type.CollectionUtils;
import com.valor.mfc.vms.meta.model.database.dao.MetaDao;
import com.valor.mfc.vms.meta.model.database.ddo.control.MovieMetaChanged;
import com.valor.mfc.vms.meta.model.database.ddo.media.Meta4Query;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.Season;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.Series;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.SeriesLocale;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesArtwork;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesAward;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesCastCrew;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesCertification;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesCountry;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesGenre;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesReleaseInfo;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesSimilar;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesSynopsis;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesTitleAKA;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesTrailer;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesUserReview;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.Video;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoArtwork;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoAward;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoCastCrew;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoCertification;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoCountry;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoGenre;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoLocale;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoParentsGuide;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoReleaseInfo;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoSimilar;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoSynopsis;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoTitleAKA;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoTrailer;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoUserReview;
import com.valor.mfc.vms.meta.model.database.ddo.person.AbstractPersonFilmography;
import com.valor.mfc.vms.meta.model.database.ddo.person.Person;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonAward;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonFilmography;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonFilmography2;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonKnowFor;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonLocale;
import com.valor.mfc.vms.meta.model.database.dto.PersonDto;
import com.valor.mfc.vms.meta.model.database.dto.PersonDto4Merge;
import com.valor.mfc.vms.meta.model.database.dto.TVMetaDto;
import com.valor.mfc.vms.meta.model.database.dto.TVMetaDto4Merge;
import com.valor.mfc.vms.meta.model.database.dto.VideoMetaDto;
import com.valor.mfc.vms.meta.model.database.dto.VideoMetaDto4Merge;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by Frank.Huang on 2016/5/7.
 */
@Deprecated
@Service
public class VmsMetaWrapper {

    private static final Logger logger = LoggerFactory.getLogger(VmsMetaWrapper.class);

    @Autowired
    private MetaDao metaDao;

    /**
     *
     * @param id
     * @param language
     * @return
     */
    public PersonDto getPerson4Sync(boolean enableCache, long id, String language,String field){
        PersonDto personDto = new PersonDto();
        Map<String,Object> idCriteria = ImmutableMap.of("id",id);
        Map<String,Object> idLanguageCriteria = ImmutableMap.of("id",id,"language",language);
        
        personDto.setPerson((Person) metaDao.getData(enableCache,Person.class,idCriteria));
        personDto.setLocale((PersonLocale)metaDao.getData(enableCache,PersonLocale.class, idCriteria));
        personDto.setAwards(metaDao.getSetData(enableCache,PersonAward.class,ImmutableMap.of("id", id)));
        personDto.setKnowFors(metaDao.getSetData(enableCache,PersonKnowFor.class,ImmutableMap.of("personId", id)));
        Set<AbstractPersonFilmography> pfSet = Sets.newHashSet();
        pfSet.addAll(metaDao.getSetData(enableCache,PersonFilmography.class,ImmutableMap.of("personId", id)));
        pfSet.addAll(metaDao.getSetData(enableCache,PersonFilmography2.class,ImmutableMap.of("personId", id)));
        personDto.setFilmographies(pfSet);

        return personDto;
    }

    public PersonDto4Merge getPerson4Merge(long id, String language,String field){
        PersonDto4Merge personDto4Merge = new PersonDto4Merge(getPerson4Sync(false,id,language,field),field);
        return personDto4Merge;
    }

    public Map<Long, PersonDto> getPersons4List(boolean enableCache,Set<Long> ids, String language,boolean showNameOnly){
        Map<String,Object> idCriteria = ImmutableMap.of("id",ids);
        Map<String,Object> idLanguageCriteria = ImmutableMap.of("id",ids,"language",language);

        Map<Long, PersonDto> personMap = Maps.newHashMap();
        List<Person> personList = metaDao.getListDataIn(enableCache,Person.class,idCriteria);
        if (CollectionUtils.isNullOrEmpty(personList)){
            return personMap;
        }

        List<PersonLocale> personLocaleList = Lists.newArrayList();
        if (!showNameOnly){
            personLocaleList = metaDao.getListDataIn(enableCache,PersonLocale.class,idLanguageCriteria);
            if (CollectionUtils.isNullOrEmpty(personLocaleList)){
                personLocaleList = metaDao.getListDataIn(enableCache,PersonLocale.class,ImmutableMap.of("id", ids, "language", "en"));
            }
        }


        Map<Long, PersonLocale> localeMap = Maps.newHashMap();
        if (!CollectionUtils.isNullOrEmpty(personLocaleList)){
            personLocaleList.forEach(e->{
                localeMap.put(e.getId(),e);
            });
        }

        personList.forEach(e->{
            PersonDto personDto = new PersonDto();
            personDto.setPerson(e);
            personDto.setLocale(localeMap.get(e.getId()));

            personMap.put(e.getId(),personDto);
        });


        return personMap;
    }



    public VideoMetaDto getVideoMeta(boolean enableCache,long id, String language){
        Map<String,Object> idCriteria = ImmutableMap.of("id",id);
        Map<String,Object> idLanguageCriteria = ImmutableMap.of("id",id,"language",language);

        VideoMetaDto meta = new VideoMetaDto();

        meta.setVideo((Video) metaDao.getData(enableCache,Video.class,idCriteria));

        if (meta.isInvaild()){
            return meta;
        }

        meta.setVideoLocale((VideoLocale) metaDao.getData(enableCache,VideoLocale.class,idLanguageCriteria));
        meta.setTrailers(metaDao.getSetData(enableCache,VideoTrailer.class, idLanguageCriteria));
        meta.setArtworks(metaDao.getSetData(enableCache,VideoArtwork.class, idLanguageCriteria));
        meta.setSynopsises(metaDao.getSetData(enableCache,VideoSynopsis.class, idLanguageCriteria));
        meta.setUserReviews(metaDao.getSetData(enableCache,VideoUserReview.class, idLanguageCriteria));
        meta.setGenres(metaDao.getSetData(enableCache,VideoGenre.class, idCriteria));
        meta.setCountries(metaDao.getSetData(enableCache,VideoCountry.class, idCriteria));
        meta.setCerts(metaDao.getSetData(enableCache,VideoCertification.class, idCriteria));
        meta.setReleaseInfos(metaDao.getSetData(enableCache,VideoReleaseInfo.class, idCriteria));
        meta.setSimilors(metaDao.getSetData(enableCache,VideoSimilar.class, idCriteria));
        meta.setTitleAkas(metaDao.getSetData(enableCache,VideoTitleAKA.class, idCriteria));
        meta.setAwards(metaDao.getSetData(enableCache,VideoAward.class, idCriteria));

        meta.setCasts(metaDao.getSetData(enableCache,VideoCastCrew.class, ImmutableMap.of("mediaId",id)));

//        Set<Long> personIds = Sets.newHashSet();
//        meta.getCasts().forEach(e->{
//            personIds.add(e.getPersonId());
//        });
//
//        if (!personIds.isEmpty()){
//            Map<Long,PersonDto> personDtoMap = getPersons4List(enableCache,personIds,language);
//            meta.setPersons(Sets.newHashSet(personDtoMap.values()));
//        }

        return meta;
    }

    public VideoMetaDto4Merge getVideoMeta4Merge(long id, String language,String field){
        Map<String,Object> idCriteria = ImmutableMap.of("id",id);
        Map<String,Object> idLanguageCriteria = ImmutableMap.of("id",id,"language",language);

        VideoMetaDto4Merge meta = new VideoMetaDto4Merge(field);
        meta.setVideo((Video) metaDao.getData(false,Video.class,idCriteria));

        if (meta.isInvaild()){
            return meta;
        }

        meta.setMeta4Query((Meta4Query) metaDao.getData(false,Meta4Query.class,idCriteria));
        if (SyncFieldTools.isImage(field)){
            meta.setArtworks(metaDao.getSetData(false, VideoArtwork.class, idLanguageCriteria));
        }

        if (SyncFieldTools.isMeta(field)){
            meta.setArtworks(metaDao.getSetData(false, VideoArtwork.class, idLanguageCriteria));
            meta.setVideoLocales(metaDao.getSetData(false, VideoLocale.class, idCriteria));
            meta.setSynopsises(metaDao.getSetData(false,VideoSynopsis.class, idLanguageCriteria));
            meta.setUserReviews(metaDao.getSetData(false,VideoUserReview.class, idLanguageCriteria));
            meta.setParentsGuides(metaDao.getSetData(false,VideoParentsGuide.class, idLanguageCriteria));

            if (LanguageTools.isEnglish(language)) {
                meta.setTrailers(metaDao.getSetData(false, VideoTrailer.class, idLanguageCriteria));

                meta.setGenres(metaDao.getSetData(false, VideoGenre.class, idCriteria));
                meta.setCountries(metaDao.getSetData(false, VideoCountry.class, idCriteria));
                meta.setCerts(metaDao.getSetData(false, VideoCertification.class, idCriteria));
                meta.setReleaseInfos(metaDao.getSetData(false, VideoReleaseInfo.class, idCriteria));
                meta.setSimilars(metaDao.getSetData(false, VideoSimilar.class, idCriteria));
                meta.setTitleAkas(metaDao.getSetData(false, VideoTitleAKA.class, idCriteria));
                meta.setAwards(metaDao.getSetData(false, VideoAward.class, idCriteria));
                meta.setCasts(metaDao.getSetData(false, VideoCastCrew.class, ImmutableMap.of("mediaId", id)));
            }
        }

        return meta;
    }


    public TVMetaDto getTVMeta4web(boolean cahceEnable, long id, String language, boolean withPerson){
        Map<String,Object> idCriteria = ImmutableMap.of("id",id);
        Map<String,Object> idLanguageCriteria = ImmutableMap.of("id",id,"language",language);

        TVMetaDto meta = new TVMetaDto();

        meta.setSeries((Series) metaDao.getData(cahceEnable,Series.class,idCriteria));
        if (meta.isInvaild()){
            return meta;
        }

        meta.setSeriesLocale((SeriesLocale) metaDao.getData(cahceEnable,SeriesLocale.class, idLanguageCriteria));
        meta.setSeasons(metaDao.getSetData(cahceEnable,Season.class, ImmutableMap.of("seriesId",id)));
        //meta.setEpisodes(metaDao.getSetData(cahceEnable,Video.class, ImmutableMap.of("seriesId",id)));

        //meta.setCasts(metaDao.getSetData(cahceEnable,TVSeriesCastCrew.class, ImmutableMap.of("mediaId",id)));
        meta.setGenres(metaDao.getSetData(cahceEnable,TVSeriesGenre.class, idCriteria));
        meta.setCountries(metaDao.getSetData(cahceEnable,TVSeriesCountry.class, idCriteria));
        meta.setCerts(metaDao.getSetData(cahceEnable,TVSeriesCertification.class, idCriteria));
        meta.setReleaseInfos(metaDao.getSetData(cahceEnable,TVSeriesReleaseInfo.class, idCriteria));
        meta.setTitleAkas(metaDao.getSetData(cahceEnable,TVSeriesTitleAKA.class, idCriteria));

        meta.setTrailers(metaDao.getSetData(cahceEnable,TVSeriesTrailer.class, idCriteria));
        //meta.setArtworks(metaDao.getSetData(cahceEnable,TVSeriesArtwork.class, idLanguageCriteria));
        
        if (!LanguageTools.isEnglish(language)){
//            if (CollectionUtils.isNullOrEmpty(meta.getArtworks())){
//                meta.setArtworks(metaDao.getSetData(cahceEnable,TVSeriesArtwork.class, ImmutableMap.of("id",id,"language",LanguageTools.LANG_EN)));
//            }

//            if (CollectionUtils.isNullOrEmpty(meta.getTrailers())){
//                meta.setTrailers(metaDao.getSetData(cahceEnable,TVSeriesTrailer.class, ImmutableMap.of("id",id,"language",LanguageTools.LANG_EN)));
//            }

            if (meta.getSeriesLocale()==null){
                meta.setSeriesLocale((SeriesLocale) metaDao.getData(cahceEnable,SeriesLocale.class, ImmutableMap.of("id",id,"language",LanguageTools.LANG_EN)));
            }
        }

        return meta;
    }

    public TVMetaDto4Merge getTVMeta4Merge(long id, String language,String field){
        Map<String,Object> idCriteria = ImmutableMap.of("id",id);
        Map<String,Object> idLanguageCriteria = ImmutableMap.of("id",id,"language",language);

        TVMetaDto4Merge meta = new TVMetaDto4Merge(field);

        meta.setSeries((Series) metaDao.getData(false,Series.class,idCriteria),false);
        if (meta.isInvaild()){
            return meta;
        }

        meta.setMeta4Query((Meta4Query) metaDao.getData(false,Meta4Query.class,idCriteria));

        if (SyncFieldTools.isImage(field)){
            meta.setArtworks(metaDao.getSetData(false, TVSeriesArtwork.class, idLanguageCriteria));
        }

        if (SyncFieldTools.isMeta(field)){
            meta.setArtworks(metaDao.getSetData(false, TVSeriesArtwork.class, idLanguageCriteria));
            meta.setSeriesLocales(metaDao.getSetData(false,SeriesLocale.class, idCriteria));
            meta.setParentsGuides(metaDao.getSetData(false,VideoParentsGuide.class, idLanguageCriteria));
            meta.setSynopsises(metaDao.getSetData(false, TVSeriesSynopsis.class, idLanguageCriteria));
            meta.setUserReviews(metaDao.getSetData(false, TVSeriesUserReview.class, idLanguageCriteria));

            if (LanguageTools.isEnglish(language)) {
                meta.setSeasons(metaDao.getSetData(false,Season.class, ImmutableMap.of("seriesId",id)));
                meta.setEpisodes(metaDao.getSetData(false,Video.class, ImmutableMap.of("seriesId",id)));
                meta.setTrailers(metaDao.getSetData(false, TVSeriesTrailer.class, idLanguageCriteria));
                meta.setGenres(metaDao.getSetData(false, TVSeriesGenre.class, idCriteria));
                meta.setCountries(metaDao.getSetData(false, TVSeriesCountry.class, idCriteria));
                meta.setCerts(metaDao.getSetData(false, TVSeriesCertification.class, idCriteria));
                meta.setReleaseInfos(metaDao.getSetData(false, TVSeriesReleaseInfo.class, idCriteria));
                meta.setSimilars(metaDao.getSetData(false, TVSeriesSimilar.class, idCriteria));
                meta.setTitleAkas(metaDao.getSetData(false, TVSeriesTitleAKA.class, idCriteria));
                meta.setAwards(metaDao.getSetData(false, TVSeriesAward.class, idCriteria));
                meta.setCasts(metaDao.getSetData(false, TVSeriesCastCrew.class, ImmutableMap.of("mediaId", id)));
            }
        }


        return meta;
    }

    public void saveMeta(VideoMetaDto4Merge meta){
        StatTools.startSrvTimer("save-video");
        metaDao.storeVideoMeta(meta);
        StatTools.stopSrvTimer("save-video");
    }

    public void saveMeta(PersonDto4Merge meta){
        StatTools.startSrvTimer("save-person");
        metaDao.savePerson(meta);
        StatTools.stopSrvTimer("save-person");
    }

    public void saveMetaChanged(EVideoType type,long id, String language, int status){
        StatTools.startSrvTimer("save-changed");
        MovieMetaChanged changed = new MovieMetaChanged(id,language,status);
        changed.setMediaType(type);
        metaDao.storeEntity(changed);
        StatTools.stopSrvTimer("save-changed");
    }

}
