/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.database.dao;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.valor.mfc.vms.api.model.cloud.ECloudAcctType;
import com.valor.mfc.vms.api.model.constant.EArtworkType;
import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.api.model.tools.MediaTypeTools;
import com.valor.mfc.vms.cloud.model.database.ddo.LinkedUserCloudAccountDdo;
import com.valor.mfc.vms.cloud.model.database.ddo.LinkedUserCloudDdo;
import com.valor.mfc.vms.cloud.model.database.ddo.LinkedUserCloudDeviceDdo;
import com.valor.mfc.vms.cloud.model.database.dto.UserCloudBaseDto;
import com.valor.mfc.vms.common.tools.meta.LanguageTools;
import com.valor.mfc.vms.common.tools.type.CollectionUtils;
import com.valor.mfc.vms.common.tools.type.DateTimeTools;
import com.valor.mfc.vms.meta.model.database.dao.AbstractMetaBaseDao;
import com.valor.mfc.vms.meta.model.database.ddo.identifier.Identifier;
import com.valor.mfc.vms.meta.model.database.ddo.index.MetaIndex;
import com.valor.mfc.vms.meta.model.database.ddo.index.PersonIndex;
import com.valor.mfc.vms.meta.model.database.ddo.linked.LinkedCacheDdo;
import com.valor.mfc.vms.meta.model.database.ddo.linked.LinkedCloudDdo;
import com.valor.mfc.vms.meta.model.database.ddo.media.Meta4Query;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractArtwork;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVSeriesArtwork;
import com.valor.mfc.vms.meta.model.database.ddo.media.tv.TVTrakttvOnTheAirFromTrakt;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.Video;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoArtwork;
import com.valor.mfc.vms.meta.model.database.ddo.mm.Intheater.MMMovieInTheater;
import com.valor.mfc.vms.meta.model.database.dto.PersonDto;
import com.valor.mfc.vms.meta.model.database.dto.PersonDto4Merge;
import com.valor.mfc.vms.meta.model.database.dto.TVMetaDto4Merge;
import com.valor.mfc.vms.meta.model.database.dto.VideoMetaDto4Merge;
import com.valor.mfc.vms.meta.model.util.IdentifierUtil;
import common.base.tools.stat.StatTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(value="metaTransactionManager")
public class MetaDao
extends AbstractMetaBaseDao {
    private static final Logger logger = LoggerFactory.getLogger(MetaDao.class);
    @Autowired
    protected SessionFactory metaSessionFactory;

    @Override
    @Transactional(value="metaTransactionManager")
    public Session currentSession() {
        return this.metaSessionFactory.getCurrentSession();
    }

    @Override
    @Transactional(value="metaTransactionManager")
    public void storeEntity(Object entity) {
        super.storeEntity(entity);
    }

    @Override
    @Transactional(value="metaTransactionManager")
    public void deleteEntity(Object entity) {
        this.currentSession().delete(entity);
    }

    @Override
    @Transactional(value="metaTransactionManager")
    public void storeAllIfAbsent(Collection entities) {
        super.storeAllIfAbsent(entities);
    }

    @Override
    @Transactional(value="metaTransactionManager")
    public void deleteAll(Collection entities) {
        super.deleteAll(entities);
    }

    @Override
    @Transactional(value="metaTransactionManager")
    public void storeAll(Collection entities) {
        super.storeAll(entities);
    }

    @Override
    @Transactional(value="metaTransactionManager")
    public int executeUpdate(CharSequence queryCharSequence) {
        return super.executeUpdate(queryCharSequence);
    }

    @Override
    @Transactional(value="metaTransactionManager")
    public int excuteSql(String sql) {
        return super.excuteSql(sql);
    }

    public List<Identifier> getIdentifier() {
        return this.currentSession().createCriteria(Identifier.class).list();
    }

    @Transactional(value="metaTransactionManager", readOnly=true)
    public MetaIndex getMetaIndex(String imdbId) {
        return (MetaIndex)((Object)this.currentSession().createCriteria(MetaIndex.class).add((Criterion)Restrictions.eq((String)"imdbId", (Object)imdbId)).uniqueResult());
    }

    @Transactional(value="metaTransactionManager", readOnly=true)
    public PersonIndex getPersonIndex(String imdbId) {
        return (PersonIndex)((Object)this.currentSession().createCriteria(PersonIndex.class).add((Criterion)Restrictions.eq((String)"imdbId", (Object)imdbId)).uniqueResult());
    }

    @Transactional(value="metaTransactionManager", readOnly=true)
    public MetaIndex getMetaIndexByPpId(String ppId) {
        return (MetaIndex)((Object)this.currentSession().createCriteria(MetaIndex.class).add((Criterion)Restrictions.eq((String)"ppId", (Object)ppId)).uniqueResult());
    }

    @Transactional(value="metaTransactionManager", readOnly=true)
    public PersonIndex getPersonIndexByPcId(String pcId) {
        return (PersonIndex)((Object)this.currentSession().createCriteria(PersonIndex.class).add((Criterion)Restrictions.eq((String)"pcId", (Object)pcId)).uniqueResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(value="metaTransactionManager", readOnly=true)
    public Map<String, MetaIndex> getMetaIndexByPpIds(Set<String> ppIds) {
        HashMap indexMap = Maps.newHashMap();
        if (ppIds.isEmpty()) {
            return indexMap;
        }
        try {
            StatTools.startDBTimer((String)"getMetaIndexByPpId");
            List ids = this.currentSession().createCriteria(MetaIndex.class).add(Restrictions.in((String)"ppId", ppIds)).list();
            ids.forEach(e -> indexMap.put(e.getPpId().toLowerCase(), e));
            HashMap hashMap = indexMap;
            return hashMap;
        }
        finally {
            StatTools.stopDBTimer((String)"getMetaIndexByImdbId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(value="metaTransactionManager")
    public List getListData(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        StatTools.startDBTimer((String)returnType.getSimpleName());
        try {
            List list = super.getListData(enableCahce, returnType, filters);
            return list;
        }
        finally {
            StatTools.stopDBTimer((String)returnType.getSimpleName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(value="metaTransactionManager")
    public Object getData(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        StatTools.startDBTimer((String)returnType.getSimpleName());
        try {
            Object object = super.getData(enableCahce, returnType, filters);
            return object;
        }
        finally {
            StatTools.stopDBTimer((String)returnType.getSimpleName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(value="metaTransactionManager")
    public List getListDataIn(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        try {
            StatTools.startDBTimer((String)returnType.getSimpleName());
            List list = super.getListDataIn(enableCahce, returnType, filters);
            return list;
        }
        finally {
            StatTools.stopDBTimer((String)returnType.getSimpleName());
        }
    }

    @Override
    @Transactional(value="metaTransactionManager")
    public Set getSetData(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        HashSet set = new HashSet(this.getListData(enableCahce, returnType, filters));
        return set;
    }

    @Transactional(value="metaTransactionManager")
    public void storePerson(PersonDto personDto) {
        if (personDto.isValid()) {
            this.storeEntity((Object)personDto.getPerson());
            this.storeAllIfAbsent(personDto.getMlLocales());
            this.storeAllIfAbsent(personDto.getKnowFors());
            this.storeAllIfAbsent(personDto.getAwards());
            this.storeAllIfAbsent(personDto.getFilmographies());
        }
    }

    @Transactional(value="metaTransactionManager")
    public void savePerson(PersonDto4Merge personDto4Merge) {
        if (personDto4Merge.isValid()) {
            Set<Object> delSet = personDto4Merge.getToBeDelSet();
            if (!CollectionUtils.isNullOrEmpty(delSet)) {
                this.deleteAll(delSet);
            }
            this.storeEntity((Object)personDto4Merge.getPerson());
            this.storeEntity((Object)personDto4Merge.getLocale());
            this.storeAllIfAbsent(personDto4Merge.getMlLocales());
            this.storeAllIfAbsent(personDto4Merge.getKnowFors());
            this.storeAllIfAbsent(personDto4Merge.getAwards());
            this.storeAllIfAbsent(personDto4Merge.getFilmographies());
            this.storeAllIfAbsent(personDto4Merge.getEsAward());
            this.storeAllIfAbsent(personDto4Merge.getPtAward());
            this.storeAllIfAbsent(personDto4Merge.getPersonTags());
            logger.info("[PERSON]{}", (Object)personDto4Merge.dumpSyncStat(personDto4Merge.getPerson().getId(), personDto4Merge.getPerson().getImdbId(), EVideoType.PERSON));
        }
    }

    @Transactional(value="metaTransactionManager")
    public void storeVideoMeta(VideoMetaDto4Merge meta) {
        Set<Object> delSet = meta.getToBeDelSet();
        if (!CollectionUtils.isNullOrEmpty(delSet)) {
            this.deleteAll(delSet);
        }
        this.storeEntity((Object)meta.getVideo());
        this.storeEntity((Object)meta.getMeta4Query());
        this.storeAllIfAbsent(meta.getVideoLocales());
        this.storeAllIfAbsent(meta.getTrailers());
        this.storeAllIfAbsent(meta.getArtworks());
        this.storeAllIfAbsent(meta.getSynopsises());
        this.storeAllIfAbsent(meta.getUserReviews());
        this.storeAllIfAbsent(meta.getGenres());
        this.storeAllIfAbsent(meta.getCountries());
        this.storeAllIfAbsent(meta.getCerts());
        this.storeAllIfAbsent(meta.getReleaseInfos());
        this.storeAllIfAbsent(meta.getCasts());
        this.storeAllIfAbsent(meta.getFilmographies());
        this.storeAllIfAbsent(meta.getSimilars());
        this.storeAllIfAbsent(meta.getTitleAkas());
        this.storeAllIfAbsent(meta.getParentsGuides());
        this.storeAllIfAbsent(meta.getAwards());
        this.storeAllIfAbsent(meta.getCompanies());
        meta.getPersons().forEach(e -> this.storePerson((PersonDto)e));
        if (meta.getVideo() != null) {
            logger.info("[META][VIDEO]{}", (Object)meta.dumpSyncStat(meta.getVideo().getId(), meta.getVideo().getMetaId(), meta.getVideo().getType()));
        }
    }

    public void deleteTVMeta(TVMetaDto4Merge meta) {
    }

    public void updateTVMeta(TVMetaDto4Merge meta) {
        Set<Object> delSet = meta.getToBeDelSet();
        if (!CollectionUtils.isNullOrEmpty(delSet)) {
            this.deleteAll(delSet);
        }
        this.storeEntity((Object)meta.getSeries());
        this.storeEntity((Object)meta.getMeta4Query());
        this.storeAllIfAbsent(meta.getSeriesLocals());
        this.storeAllIfAbsent(meta.getTrailers());
        this.storeAllIfAbsent(meta.getArtworks());
        this.storeAllIfAbsent(meta.getSynopsises());
        this.storeAllIfAbsent(meta.getUserReviews());
        this.storeAllIfAbsent(meta.getGenres());
        this.storeAllIfAbsent(meta.getCountries());
        this.storeAllIfAbsent(meta.getCerts());
        this.storeAllIfAbsent(meta.getFilmographies());
        this.storeAllIfAbsent(meta.getReleaseInfos());
        this.storeAllIfAbsent(meta.getCasts());
        this.storeAllIfAbsent(meta.getSimilars());
        this.storeAllIfAbsent(meta.getTitleAkas());
        this.storeAllIfAbsent(meta.getAwards());
        this.storeAllIfAbsent(meta.getCompanies());
        this.storeAllIfAbsent(meta.getParentsGuides());
        this.storeAllIfAbsent(meta.getSeasons());
        this.storeAllIfAbsent(meta.getEpisodes());
        logger.info("[META][SERIES]{}", (Object)meta.dumpSyncStat(meta.getSeries()));
    }

    public void updateTV(TVMetaDto4Merge meta) {
        this.deleteTVMeta(meta);
        this.updateTVMeta(meta);
    }

    public Map<String, MetaIndex> getMetaIndexByMetaId(Set<String> metaIds) {
        Map<Long, MetaIndex> vmsIndexs;
        Map<Object, Object> indexMap = Maps.newHashMap();
        if (metaIds.isEmpty()) {
            return indexMap;
        }
        HashSet imdbIds = Sets.newHashSet();
        HashSet vmsIds = Sets.newHashSet();
        metaIds.forEach(e -> {
            if (!Strings.isNullOrEmpty((String)e)) {
                if (e.startsWith("mm")) {
                    vmsIds.add(IdentifierUtil.getInternalId(e));
                } else {
                    imdbIds.add(e);
                }
            }
        });
        if (!CollectionUtils.isNullOrEmpty((Collection)imdbIds)) {
            indexMap = this.getMetaIndexByImdbId(imdbIds);
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)vmsIds) && !CollectionUtils.isNullOrEmpty(vmsIndexs = this.getMetaIndexByVmsId(vmsIds))) {
            for (Map.Entry<Long, MetaIndex> entity : vmsIndexs.entrySet()) {
                indexMap.put(IdentifierUtil.getDisplayId(entity.getKey()), (Object)entity.getValue());
            }
        }
        return indexMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, MetaIndex> getMetaIndexByImdbId(Set<String> imdbIds) {
        HashMap indexMap = Maps.newHashMap();
        if (imdbIds.isEmpty()) {
            return indexMap;
        }
        try {
            StatTools.startDBTimer((String)"getMetaIndexByImdbId");
            List ids = this.currentSession().createCriteria(MetaIndex.class).add(Restrictions.in((String)"imdbId", imdbIds)).list();
            ids.forEach(e -> indexMap.put(e.getImdbId(), e));
            HashMap hashMap = indexMap;
            return hashMap;
        }
        finally {
            StatTools.stopDBTimer((String)"getMetaIndexByImdbId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, MetaIndex> getMetaIndexByVmsId(Set<Long> ids) {
        HashMap indexMap = Maps.newHashMap();
        if (ids.isEmpty()) {
            return indexMap;
        }
        try {
            StatTools.startDBTimer((String)"getMetaIndexByVmsId");
            List idIndexs = this.currentSession().createCriteria(MetaIndex.class).add(Restrictions.in((String)"vmsId", ids)).list();
            idIndexs.forEach(e -> indexMap.put(e.getVmsId(), e));
            HashMap hashMap = indexMap;
            return hashMap;
        }
        finally {
            StatTools.stopDBTimer((String)"getMetaIndexByVmsId");
        }
    }

    public Map<String, Long> getVmsIdsByImdbId(Set<String> imdbIds) {
        HashMap localIds = Maps.newHashMap();
        if (imdbIds.isEmpty()) {
            return localIds;
        }
        List ids = this.currentSession().createCriteria(MetaIndex.class).setCacheable(true).setReadOnly(true).add(Restrictions.in((String)"imdbId", imdbIds)).list();
        ids.forEach(e -> localIds.put(e.getImdbId(), e.getVmsId()));
        return localIds;
    }

    public Map<String, Long> getVmsIdsByPpId(Set<String> ppIds) {
        HashMap localIds = Maps.newHashMap();
        if (ppIds.isEmpty()) {
            return localIds;
        }
        List ids = this.currentSession().createCriteria(MetaIndex.class).setCacheable(true).setReadOnly(true).add(Restrictions.in((String)"ppId", ppIds)).list();
        ids.forEach(e -> localIds.put(e.getPpId(), e.getVmsId()));
        return localIds;
    }

    public Map<String, Long> getPersonIdByImdbId(Set<String> imdbIds) {
        HashMap localIds = Maps.newHashMap();
        if (CollectionUtils.isNullOrEmpty(imdbIds)) {
            return localIds;
        }
        List ids = this.currentSession().createCriteria(PersonIndex.class).setCacheable(true).setReadOnly(true).add(Restrictions.in((String)"imdbId", imdbIds)).list();
        ids.forEach(e -> localIds.put(e.getImdbId(), e.getVmsId()));
        return localIds;
    }

    public Map<String, PersonIndex> getPersonIndexByImdbId(Set<String> imdbIds) {
        HashMap localIds = Maps.newHashMap();
        if (CollectionUtils.isNullOrEmpty(imdbIds)) {
            return localIds;
        }
        List ids = this.currentSession().createCriteria(PersonIndex.class).setCacheable(true).setReadOnly(true).add(Restrictions.in((String)"imdbId", imdbIds)).list();
        ids.forEach(e -> localIds.put(e.getImdbId(), e));
        return localIds;
    }

    public Map<String, PersonIndex> getPersonIndexByPcIdSet(Set<String> pcIds) {
        HashMap localMap = Maps.newHashMap();
        if (CollectionUtils.isNullOrEmpty(pcIds)) {
            return localMap;
        }
        List ids = this.currentSession().createCriteria(PersonIndex.class).setCacheable(true).setReadOnly(true).add(Restrictions.in((String)"pcId", pcIds)).list();
        ids.forEach(e -> localMap.put(e.getPcId(), e));
        return localMap;
    }

    public Set difference(Set set1, Set set2) {
        return Sets.difference((Set)set1, (Set)set2);
    }

    public void deleteByImdbId(String imdbId) {
        logger.info("Delete data:{}", (Object)imdbId);
        MetaIndex index = (MetaIndex)((Object)this.getData(false, MetaIndex.class, (Map<String, Object>)ImmutableMap.of((Object)"imdbId", (Object)imdbId)));
        if (index != null) {
            this.excuteSql("delete from vms_video where id=" + index.getVmsId());
            this.excuteSql("delete from vms_video_locale where id=" + index.getVmsId());
            this.excuteSql("delete from vms_video_artwork where id=" + index.getVmsId());
            this.excuteSql("delete from vms_video_awards where id=" + index.getVmsId());
            this.excuteSql("delete from vms_video_certification where id=" + index.getVmsId());
            this.excuteSql("delete from vms_video_country where id=" + index.getVmsId());
            this.excuteSql("delete from vms_video_genre where id=" + index.getVmsId());
            this.excuteSql("delete from vms_video_release_info where id=" + index.getVmsId());
            this.excuteSql("delete from vms_video_similar where id=" + index.getVmsId());
            this.excuteSql("delete from vms_video_synopsis where id=" + index.getVmsId());
            this.excuteSql("delete from vms_video_trailer where id=" + index.getVmsId());
            this.excuteSql("delete from vms_video_userreview where id=" + index.getVmsId());
            this.excuteSql("delete from vms_video_castcrew where media_id=" + index.getVmsId());
            this.excuteSql("delete from meta_index where vms_id=" + index.getVmsId());
        }
    }

    @Override
    public long criteriaQueryCount(Class valueType) {
        return super.criteriaQueryCount(valueType);
    }

    public void deletePersonInfo(long id) {
        int ret1 = this.excuteSql("delete from vms_person_filmography where person_id=" + id);
        int ret2 = this.excuteSql("delete from vms_person_knownfor where person_id=" + id);
        int ret3 = this.excuteSql("delete from vms_person_award where id=" + id);
        logger.info("Delete person[{}] info filmography [{}] knownfor[{}]  award[{}]", new Object[]{id, ret1, ret2, ret3});
    }

    @Override
    public String getLatestUpdateTime(Class clazz, Map<String, Object> filters) {
        return super.getLatestUpdateTime(clazz, filters);
    }

    @Override
    public Date getLatestUpdateDate(Class clazz, Map<String, Object> filters) {
        return super.getLatestUpdateDate(clazz, filters);
    }

    public List<LinkedCloudDdo> queryLinkedFile(Set<Long> ids) {
        return this.getListDataIn(false, LinkedCloudDdo.class, (Map<String, Object>)ImmutableMap.of((Object)"videoId", ids));
    }

    public Map<Long, Integer> queryLinkedStatus(Set<Long> ids) {
        HashMap linkedMap = Maps.newHashMap();
        if (CollectionUtils.isNullOrEmpty(ids)) {
            return linkedMap;
        }
        List<LinkedCloudDdo> linkedClouds = this.queryLinkedFile(ids);
        if (CollectionUtils.isNullOrEmpty(linkedClouds)) {
            return linkedMap;
        }
        linkedClouds.forEach(e -> linkedMap.put(e.getVideoId(), 1));
        return linkedMap;
    }

    public String getMaxOnAirTodayDate() {
        Criteria criteria = this.currentSession().createCriteria(TVTrakttvOnTheAirFromTrakt.class);
        criteria.setReadOnly(true);
        criteria.add((Criterion)Restrictions.le((String)"lastAirDate", (Object)DateTimeTools.currentDateStr2()));
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Projections.max((String)"lastAirDate")));
        return (String)criteria.uniqueResult();
    }

    public List<LinkedCacheDdo> queryLinkedCache(Date date) {
        Criteria criteria = this.currentSession().createCriteria(LinkedCacheDdo.class);
        criteria.setReadOnly(true);
        if (date != null) {
            criteria.add((Criterion)Restrictions.gt((String)"lastModifyTime", (Object)date));
        }
        return criteria.list();
    }

    public int updateLinkedTime(long id, long linkedTime) {
        StringBuffer sb = new StringBuffer();
        sb.append("update vms_meta_for_query");
        sb.append(" set linked=1,linked_time=").append(linkedTime);
        sb.append(" where id=").append(id);
        int effectCount = this.executeSqlUpdate(sb);
        logger.info("update [{}] linked time to [{}], effectCount:[{}]", new Object[]{id, linkedTime, effectCount});
        return effectCount;
    }

    public Meta4Query getMeta4Query(long id, EVideoType type) {
        return (Meta4Query)((Object)this.currentSession().createCriteria(Meta4Query.class).add((Criterion)Restrictions.eq((String)"id", (Object)id)).add((Criterion)Restrictions.eq((String)"type", (Object)type)).uniqueResult());
    }

    public boolean isReduceWeight(long id, EVideoType type) {
        Meta4Query meta4Query = this.getMeta4Query(id, type);
        return this.isReduceWeight(meta4Query);
    }

    public boolean isReduceWeight(Meta4Query meta4Query) {
        if (meta4Query == null) {
            return true;
        }
        if (meta4Query.getRating() <= 0) {
            return true;
        }
        return meta4Query.getHasArtwork() == 0 || meta4Query.getHasArtwork() == 2;
    }

    public Map<EArtworkType, String> getFirstExistArtwork(Class clazz, Set<Long> ids, String language) {
        for (Long id : ids) {
            Map<EArtworkType, String> map = this.getArtworks(clazz, id, language);
            if (CollectionUtils.isNullOrEmpty(map)) continue;
            return map;
        }
        return Maps.newHashMap();
    }

    public Map<EArtworkType, String> getArtworks(Class clazz, long id, String language) {
        List artworks = this.currentSession().createCriteria(clazz).setCacheable(true).setReadOnly(true).add((Criterion)Restrictions.eq((String)"id", (Object)id)).add((Criterion)Restrictions.eq((String)"language", (Object)language)).add((Criterion)Restrictions.eq((String)"master", (Object)1)).add((Criterion)Restrictions.ne((String)"url", (Object)"")).list();
        if (CollectionUtils.isNullOrEmpty((Collection)artworks)) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        artworks.forEach(e -> {
            AbstractArtwork artwork = (AbstractArtwork)((Object)((Object)e));
            if (!Strings.isNullOrEmpty((String)artwork.getUrl().trim())) {
                map.put(artwork.getArtworkType(), artwork.getUrl());
            }
        });
        if (map.get(EArtworkType.POSTER) == null) {
            return null;
        }
        return map;
    }

    public Map<String, Video> queryVideosByImdbId(Set<String> ids) {
        HashMap videoMap = Maps.newHashMap();
        List videos = this.getListDataIn(false, Video.class, (Map<String, Object>)ImmutableMap.of((Object)"imdbId", ids));
        if (CollectionUtils.isNullOrEmpty((Collection)videos)) {
            return videoMap;
        }
        videos.forEach(e -> videoMap.put(e.getImdbId(), e));
        return videoMap;
    }

    public Map<String, Video> queryVideosByPpId(Set<String> ids) {
        HashMap videoMap = Maps.newHashMap();
        List videos = this.getListDataIn(false, Video.class, (Map<String, Object>)ImmutableMap.of((Object)"ppId", ids));
        if (CollectionUtils.isNullOrEmpty((Collection)videos)) {
            return videoMap;
        }
        videos.forEach(e -> videoMap.put(e.getPpId(), e));
        return videoMap;
    }

    public List<AbstractArtwork> queryArtworks(EVideoType mediaType, Set<Long> ids, String language, boolean isMaster, boolean enableCache) {
        return this.queryArtworks(mediaType, ids, language, isMaster, enableCache, -1);
    }

    public List<AbstractArtwork> queryArtworks(EVideoType mediaType, Set<Long> ids, String language, boolean isMaster, boolean enableCache, int maxResult) {
        Class clazz = null;
        clazz = MediaTypeTools.isSeries((EVideoType)mediaType) ? TVSeriesArtwork.class : VideoArtwork.class;
        ArrayList artworks = Lists.newArrayList();
        if (CollectionUtils.isNullOrEmpty(ids)) {
            return Lists.newArrayList();
        }
        Criteria criteria = this.currentSession().createCriteria(clazz);
        criteria.setReadOnly(true);
        criteria.setCacheable(enableCache);
        criteria.add(Restrictions.in((String)"id", ids));
        criteria.add(Restrictions.in((String)"language", (Collection)ImmutableSet.of((Object)LanguageTools.getOrDefaultLanguage((String)language), (Object)LanguageTools.LANG_EN)));
        if (isMaster) {
            criteria.add((Criterion)Restrictions.eq((String)"master", (Object)1));
        }
        if (maxResult > 0) {
            criteria.setFirstResult(0);
            criteria.setMaxResults(maxResult);
        }
        return criteria.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Meta4Query> getMeta4Query(Set<Long> ids) {
        if (CollectionUtils.isNullOrEmpty(ids)) {
            return Maps.newHashMap();
        }
        try {
            StatTools.startDBTimer((String)"getMeta4Query");
            List meta4QueryList = this.currentSession().createCriteria(Meta4Query.class).add(Restrictions.in((String)"id", ids)).list();
            HashMap meta4QueryMap = Maps.newHashMap();
            meta4QueryList.forEach(e -> meta4QueryMap.put(e.getId(), e));
            HashMap hashMap = meta4QueryMap;
            return hashMap;
        }
        finally {
            StatTools.stopDBTimer((String)"getMeta4Query");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Meta4Query> getMeta4Query2(Set<Long> ids) {
        if (CollectionUtils.isNullOrEmpty(ids)) {
            return Maps.newHashMap();
        }
        try {
            StatTools.startDBTimer((String)"getMeta4Query");
            List meta4QueryList = this.currentSession().createCriteria(Meta4Query.class).add(Restrictions.in((String)"id", ids)).list();
            HashMap meta4QueryMap = Maps.newHashMap();
            meta4QueryList.forEach(e -> meta4QueryMap.put(e.getMetaId(), e));
            HashMap hashMap = meta4QueryMap;
            return hashMap;
        }
        finally {
            StatTools.stopDBTimer((String)"getMeta4Query");
        }
    }

    public List<MMMovieInTheater> listMMMovieInTheater() {
        return this.currentSession().createCriteria(MMMovieInTheater.class).setReadOnly(true).addOrder(Order.asc((String)"status")).list();
    }

    public List<Long> getUserCloudCids(long uid, long accountId, int accountType, boolean isUserLocationIllegal) {
        LinkedHashSet cids = Sets.newLinkedHashSet();
        long startTime = System.currentTimeMillis();
        if (accountType == 1) {
            cids.addAll(this.getLinkedUserCloudAccountCids(accountId, isUserLocationIllegal));
        } else {
            cids.addAll(this.getLinkedUserCloudCids(uid, isUserLocationIllegal));
            cids.addAll(this.getLinkedUserCloudDeviceCids(uid, isUserLocationIllegal));
        }
        logger.debug("LinkedUserCloud time[{}] ", (Object)(System.currentTimeMillis() - startTime));
        return Lists.newArrayList((Iterable)cids);
    }

    public Map<Long, String> getUserCloudCidMap(long uid, long accountId, int accountType, boolean isUserLocationIllegal) {
        HashMap<Long, String> cidMap = new HashMap<Long, String>();
        long startTime = System.currentTimeMillis();
        if (accountType == 1) {
            cidMap.putAll(this.getLinkedUserCloudAccountCidMap(accountId, isUserLocationIllegal));
        } else {
            cidMap.putAll(this.getLinkedUserCloudCidMap(uid, isUserLocationIllegal));
            cidMap.putAll(this.getLinkedUserCloudDeviceCidMap(uid, isUserLocationIllegal));
        }
        logger.debug("LinkedUserCloud time[{}] ", (Object)(System.currentTimeMillis() - startTime));
        return cidMap;
    }

    private Set<Long> getLinkedUserCloudCids(long uid, boolean isUserLocationIllegal) {
        List linkedUserCloudDdos;
        LinkedHashSet cids = Sets.newLinkedHashSet();
        Criteria criteria = this.currentSession().createCriteria(LinkedUserCloudDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"uid", (Object)uid));
        if (isUserLocationIllegal) {
            criteria.add((Criterion)Restrictions.eq((String)"acctType", (Object)ECloudAcctType.PRIVATE.ordinal()));
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)(linkedUserCloudDdos = criteria.list()))) {
            linkedUserCloudDdos.forEach(e -> cids.add(e.getCid()));
        }
        return cids;
    }

    private Map<Long, String> getLinkedUserCloudCidMap(long uid, boolean isUserLocationIllegal) {
        List linkedUserCloudDdos;
        HashMap<Long, String> cidMap = new HashMap<Long, String>();
        Criteria criteria = this.currentSession().createCriteria(LinkedUserCloudDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"uid", (Object)uid));
        if (isUserLocationIllegal) {
            criteria.add((Criterion)Restrictions.eq((String)"acctType", (Object)ECloudAcctType.PRIVATE.ordinal()));
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)(linkedUserCloudDdos = criteria.list()))) {
            linkedUserCloudDdos.forEach(e -> cidMap.put(e.getCid(), e.getAcctAlias()));
        }
        return cidMap;
    }

    private Set<Long> getLinkedUserCloudAccountCids(long accountId, boolean isUserLocationIllegal) {
        LinkedHashSet cids = Sets.newLinkedHashSet();
        Criteria criteria = this.currentSession().createCriteria(LinkedUserCloudAccountDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
        if (isUserLocationIllegal) {
            criteria.add((Criterion)Restrictions.eq((String)"acctType", (Object)ECloudAcctType.PRIVATE.ordinal()));
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ne((String)"removeFlag", (Object)1), (Criterion)Restrictions.isNull((String)"removeFlag")));
        criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.gt((String)"expiredTime", (Object)System.currentTimeMillis()), Restrictions.isNull((String)"expiredTime"), Restrictions.eq((String)"expiredTime", (Object)0L)}));
        List linkedUserCloudAccountDdos = criteria.list();
        if (!CollectionUtils.isNullOrEmpty((Collection)linkedUserCloudAccountDdos)) {
            linkedUserCloudAccountDdos.forEach(e -> cids.add(e.getCid()));
        }
        return cids;
    }

    private Map<Long, String> getLinkedUserCloudAccountCidMap(long accountId, boolean isUserLocationIllegal) {
        HashMap<Long, String> cidMap = new HashMap<Long, String>();
        Criteria criteria = this.currentSession().createCriteria(LinkedUserCloudAccountDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
        if (isUserLocationIllegal) {
            criteria.add((Criterion)Restrictions.eq((String)"acctType", (Object)ECloudAcctType.PRIVATE.ordinal()));
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ne((String)"removeFlag", (Object)1), (Criterion)Restrictions.isNull((String)"removeFlag")));
        criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.gt((String)"expiredTime", (Object)System.currentTimeMillis()), Restrictions.isNull((String)"expiredTime"), Restrictions.eq((String)"expiredTime", (Object)0L)}));
        List linkedUserCloudAccountDdos = criteria.list();
        if (!CollectionUtils.isNullOrEmpty((Collection)linkedUserCloudAccountDdos)) {
            linkedUserCloudAccountDdos.forEach(e -> cidMap.put(e.getCid(), e.getAcctAlias()));
        }
        return cidMap;
    }

    private Set<Long> getLinkedUserCloudDeviceCids(long accountId, boolean isUserLocationIllegal) {
        LinkedHashSet cids = Sets.newLinkedHashSet();
        Criteria criteria = this.currentSession().createCriteria(LinkedUserCloudDeviceDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
        if (isUserLocationIllegal) {
            criteria.add((Criterion)Restrictions.eq((String)"acctType", (Object)ECloudAcctType.PRIVATE.ordinal()));
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ne((String)"removeFlag", (Object)1), (Criterion)Restrictions.isNull((String)"removeFlag")));
        criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.gt((String)"expiredTime", (Object)System.currentTimeMillis()), Restrictions.isNull((String)"expiredTime"), Restrictions.eq((String)"expiredTime", (Object)0L)}));
        List linkedUserCloudDeviceDdos = criteria.list();
        if (!CollectionUtils.isNullOrEmpty((Collection)linkedUserCloudDeviceDdos)) {
            linkedUserCloudDeviceDdos.forEach(e -> cids.add(e.getCid()));
        }
        return cids;
    }

    private Map<Long, String> getLinkedUserCloudDeviceCidMap(long accountId, boolean isUserLocationIllegal) {
        HashMap<Long, String> cidMap = new HashMap<Long, String>();
        Criteria criteria = this.currentSession().createCriteria(LinkedUserCloudDeviceDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
        if (isUserLocationIllegal) {
            criteria.add((Criterion)Restrictions.eq((String)"acctType", (Object)ECloudAcctType.PRIVATE.ordinal()));
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ne((String)"removeFlag", (Object)1), (Criterion)Restrictions.isNull((String)"removeFlag")));
        criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.gt((String)"expiredTime", (Object)System.currentTimeMillis()), Restrictions.isNull((String)"expiredTime"), Restrictions.eq((String)"expiredTime", (Object)0L)}));
        List linkedUserCloudDeviceDdos = criteria.list();
        if (!CollectionUtils.isNullOrEmpty((Collection)linkedUserCloudDeviceDdos)) {
            linkedUserCloudDeviceDdos.forEach(e -> cidMap.put(e.getCid(), e.getAcctAlias()));
        }
        return cidMap;
    }

    public Map<Long, UserCloudBaseDto> queryUserClouds(long uid, long accountId, int accountType, Set<Long> cids, boolean isPrivateOnly) {
        HashMap map = Maps.newHashMap();
        if (accountType == 1) {
            map.putAll(this.queryLinkedUserCloudAccounts(accountId, cids, isPrivateOnly));
        } else {
            map.putAll(this.queryLinkedUserClouds(uid, cids, isPrivateOnly));
            map.putAll(this.queryLinkedUserCloudDevices(accountId, cids, isPrivateOnly));
        }
        return map;
    }

    private Map<Long, UserCloudBaseDto> queryLinkedUserClouds(long uid, Set<Long> cids, boolean isPrivateOnly) {
        List linkedUserCloudDdos;
        HashMap map = Maps.newHashMap();
        Criteria criteria = this.currentSession().createCriteria(LinkedUserCloudDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"uid", (Object)uid));
        if (!CollectionUtils.isNullOrEmpty(cids)) {
            criteria.add(Restrictions.in((String)"cid", cids));
        }
        if (isPrivateOnly) {
            criteria.add((Criterion)Restrictions.ne((String)"acctType", (Object)ECloudAcctType.PUBLIC.ordinal()));
        }
        if (!CollectionUtils.isNullOrEmpty((Collection)(linkedUserCloudDdos = criteria.list()))) {
            linkedUserCloudDdos.forEach(e -> map.put(e.getCid(), new UserCloudBaseDto(e)));
        }
        return map;
    }

    private Map<Long, UserCloudBaseDto> queryLinkedUserCloudAccounts(long accountId, Set<Long> cids, boolean isPrivateOnly) {
        HashMap map = Maps.newHashMap();
        Criteria criteria = this.currentSession().createCriteria(LinkedUserCloudAccountDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
        if (!CollectionUtils.isNullOrEmpty(cids)) {
            criteria.add(Restrictions.in((String)"cid", cids));
        }
        if (isPrivateOnly) {
            criteria.add((Criterion)Restrictions.ne((String)"acctType", (Object)ECloudAcctType.PUBLIC.ordinal()));
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ne((String)"removeFlag", (Object)1), (Criterion)Restrictions.isNull((String)"removeFlag")));
        criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.gt((String)"expiredTime", (Object)System.currentTimeMillis()), Restrictions.isNull((String)"expiredTime"), Restrictions.eq((String)"expiredTime", (Object)0L)}));
        List linkedUserCloudAccountDdos = criteria.list();
        if (!CollectionUtils.isNullOrEmpty((Collection)linkedUserCloudAccountDdos)) {
            linkedUserCloudAccountDdos.forEach(e -> map.put(e.getCid(), new UserCloudBaseDto(e)));
        }
        return map;
    }

    private Map<Long, UserCloudBaseDto> queryLinkedUserCloudDevices(long accountId, Set<Long> cids, boolean isPrivateOnly) {
        HashMap map = Maps.newHashMap();
        Criteria criteria = this.currentSession().createCriteria(LinkedUserCloudDeviceDdo.class);
        criteria.add((Criterion)Restrictions.eq((String)"accountId", (Object)accountId));
        if (!CollectionUtils.isNullOrEmpty(cids)) {
            criteria.add(Restrictions.in((String)"cid", cids));
        }
        if (isPrivateOnly) {
            criteria.add((Criterion)Restrictions.ne((String)"acctType", (Object)ECloudAcctType.PUBLIC.ordinal()));
        }
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ne((String)"removeFlag", (Object)1), (Criterion)Restrictions.isNull((String)"removeFlag")));
        criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.gt((String)"expiredTime", (Object)System.currentTimeMillis()), Restrictions.isNull((String)"expiredTime"), Restrictions.eq((String)"expiredTime", (Object)0L)}));
        List linkedUserCloudDeviceDdos = criteria.list();
        if (!CollectionUtils.isNullOrEmpty((Collection)linkedUserCloudDeviceDdos)) {
            linkedUserCloudDeviceDdos.forEach(e -> map.put(e.getCid(), new UserCloudBaseDto(e)));
        }
        return map;
    }
}

