/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.database.dao.query.filter.filter;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.FilterField;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.SqlQueryBuilder;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.filter.IFieldFilter;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.filter.IFilterValueConverter;
import java.util.HashSet;

public class BaseFieldFilter
implements IFieldFilter {
    protected String tableName = "";
    protected String fieldName = "";
    protected boolean isCharacter = false;
    protected IFilterValueConverter converter = null;

    public BaseFieldFilter(String tableName, String fieldName, boolean isCharacter, IFilterValueConverter converter) {
        this.tableName = tableName;
        this.fieldName = fieldName;
        this.isCharacter = isCharacter;
        this.converter = converter;
    }

    @Override
    public String getFilter(FilterField field) {
        StringBuilder queryString = new StringBuilder();
        if (field.isRange()) {
            if (queryString.length() > 0) {
                queryString.append(" and ");
            }
            queryString.append(this.tableName).append(".").append(this.fieldName);
            queryString.append(SqlQueryBuilder.getSqlOperator(field.getOperator()));
            queryString.append(" (");
            if (this.converter == null) {
                queryString.append(Joiner.on((char)',').skipNulls().join(field.getValues()).toLowerCase().toString());
            } else {
                HashSet convValues = Sets.newHashSet();
                field.getValues().forEach(e -> convValues.add(this.converter.converter((String)e)));
                queryString.append(Joiner.on((char)',').skipNulls().join((Iterable)convValues).toLowerCase().toString());
            }
            queryString.append(") ");
        } else {
            field.getValues().forEach(e -> {
                if (queryString.length() > 0) {
                    queryString.append(" and ");
                }
                queryString.append(this.tableName).append(".").append(this.fieldName);
                queryString.append(field.getOperator());
                if (this.isCharacter) {
                    queryString.append('\'');
                }
                if (this.converter != null) {
                    queryString.append(this.converter.converter((String)e));
                } else {
                    queryString.append((String)e);
                }
                if (this.isCharacter) {
                    queryString.append('\'');
                }
            });
        }
        return queryString.toString();
    }
}

