/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.database.dao.query.filter.filter;

import com.google.common.collect.ImmutableMap;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.FilterField;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.filter.BaseFieldFilter;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.filter.CountryFilter;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.filter.GenreFilter;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.filter.IFieldFilter;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.filter.converter.LinkedTimeConverter;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.filter.converter.RatingConverter;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.filter.converter.ReleaseDateConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterTools {
    private static final Logger logger = LoggerFactory.getLogger(FilterTools.class);
    public static ImmutableMap<String, IFieldFilter> fieldFilterMap = ImmutableMap.builder().put((Object)"rating", (Object)new BaseFieldFilter("#{tab_meta}", "rating", false, new RatingConverter())).put((Object)"year", (Object)new BaseFieldFilter("#{tab_meta}", "publication_year", false, null)).put((Object)"reldate", (Object)new BaseFieldFilter("#{tab_meta}", "release_date_int", false, new ReleaseDateConverter())).put((Object)"lastAirDate", (Object)new BaseFieldFilter("#{tab_meta}", "has_reserve1", false, new ReleaseDateConverter())).put((Object)"isAnimation", (Object)new BaseFieldFilter("#{tab_meta}", "is_animation", false, null)).put((Object)"isFamlly", (Object)new BaseFieldFilter("#{tab_meta}", "is_family", false, null)).put((Object)"isHollywood", (Object)new BaseFieldFilter("#{tab_meta}", "is_hollywood", false, null)).put((Object)"isLatin", (Object)new BaseFieldFilter("#{tab_meta}", "is_latin", false, null)).put((Object)"isAsia", (Object)new BaseFieldFilter("#{tab_meta}", "is_asia", false, null)).put((Object)"notLangEN", (Object)new BaseFieldFilter("#{tab_meta}", "is_reserve1", false, null)).put((Object)"linkedTime", (Object)new BaseFieldFilter("#{tab_meta}", "linked_time", false, new LinkedTimeConverter())).put((Object)"linked", (Object)new BaseFieldFilter("#{tab_meta}", "linked", false, null)).put((Object)"genre", (Object)new GenreFilter()).put((Object)"country", (Object)new CountryFilter()).build();

    public static String buildQueryFilter(FilterField field) {
        if (field == null) {
            return "";
        }
        IFieldFilter filter = (IFieldFilter)fieldFilterMap.get((Object)field.getKey());
        if (filter == null) {
            logger.error("Can NOT filter for key[{}]", (Object)field.getKey());
            return "";
        }
        return filter.getFilter(field);
    }
}

