/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.database.tools.media;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.valor.mfc.vms.common.tools.type.CollectionUtils;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractTitleAKA;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleAkaTools {
    private static final Logger logger = LoggerFactory.getLogger(TitleAkaTools.class);
    private String original;
    private String realCountry = "";
    private String language = "";
    private int workingTitle = 0;

    public TitleAkaTools(String country) {
        this.original = country;
        this.parse();
    }

    public String getCounrty() {
        return this.realCountry;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getWorkingTitle() {
        return this.workingTitle;
    }

    private void parse() {
        if (Strings.isNullOrEmpty((String)this.original)) {
            return;
        }
        int pos = this.original.indexOf("(");
        if (pos == -1) {
            this.realCountry = this.original;
            return;
        }
        this.realCountry = this.original.substring(0, pos).trim();
        String str = this.original.substring(pos).replace("(", "");
        try {
            List titles = Splitter.on((String)")").omitEmptyStrings().trimResults().splitToList((CharSequence)str);
            titles.forEach(e -> {
                if ("working title".compareToIgnoreCase((String)e) == 0) {
                    this.workingTitle = 1;
                } else if (e.endsWith("title")) {
                    this.language = e.replace("title", "").trim();
                }
            });
        }
        catch (Exception e2) {
            logger.error("Unkown Title aka. {}", (Object)this.original);
        }
    }

    public static String getTitleAka(String language, String country, Set<AbstractTitleAKA> akas) {
        String titleAKA = "";
        if (CollectionUtils.isNullOrEmpty(akas)) {
            return "";
        }
        for (AbstractTitleAKA e : akas) {
            if (!country.equalsIgnoreCase(e.getCountry())) continue;
            if (Strings.isNullOrEmpty((String)titleAKA)) {
                titleAKA = e.getAka();
            }
            if (!language.equalsIgnoreCase(e.getLanguage())) continue;
            titleAKA = e.getAka();
        }
        return titleAKA;
    }
}

