/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.database.tools.playlist;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.valor.mfc.vms.meta.model.database.constants.EAwardCategory;
import com.valor.mfc.vms.meta.model.database.constants.EAwardEvent;
import java.util.Set;

@Deprecated
public class AwardTools {
    public static final int AWARD_PLAYLIST_ID_BASE = 10000;
    public static final int AWARD_PLAYLIST_ID_MIN = 100000;
    public static final int AWARD_PLAYLIST_ID_MAX = 100001 + EAwardEvent.END.ordinal() * 10000;
    public static final String OSCAR_BEST_FOREIGN_FILM = "Best Foreign Language Film of the Year";
    public static final String OSCAR_BEST_FILM = "Best Motion Picture of the Year";
    public static final String OSCAR_BEST_FILM_2005 = "Best Picture";
    public static final String OSCAR_BEST_FILM_1929 = "Best Picture, Production";
    public static final String OSCAR_BEST_FOREIGN_FILM_2005 = "Best Foreign Language Film";
    public static final String GOLDEN_GLOBE_BEST_FILM = "Best Motion Picture - Drama";
    public static final String GOLDEN_GLOBE_BEST_FOREIGN_FILM = "Best Motion Picture - Foreign Language";
    public static final String BAFTA_FILM = "Best Film";
    public static final String BAFTA_BEST_FOREIGN_FILM = "Best Film not in the English Language";
    public static final String GOLDEN_LION_BEST_FILE = "-1";
    public static final String GOLDEN_BERLIN_BEAR_BEST_FILM = "-1";
    public static final String GOLDEN_BERLIN_BEAR_BEST_FILM_V2 = "Best Film";
    public static final String PALME_DOR_BEST_FILM = "-1";
    public static final String EMMY_AWARDS_BEST_SERIES = "Outstanding Drama Series";
    public static final String TEEN_CHOICE_AWARDS_BEST_FILM = "Choice Movie: Drama";
    public static final String EVENT_EMMY_AWARDS = "Primetime Emmy";
    public static final String EVENT_OSCAR = "Oscar";
    public static final String EVENT_GOLDEN_GLOBE = "Golden Globe";
    public static final String EVENT_BAFTA_FILM_AWARD = "BAFTA Film Award";
    public static final String EVENT_BAFTA_TV_AWARD = "BAFTA TV Award";
    public static final String EVENT_GOLDEN_LION = "Golden Lion";
    public static final String EVENT_GOLDEN_BERLIN_BEAR = "Golden Berlin Bear";
    public static final String EVENT_PALME_DOR = "Palme d'Or";
    public static final String EVENT_TEEN_CHOICE_AWARD = "Teen Choice Award";
    public static final String ORGANIZED_EMMY_AWARDS = "Primetime Emmy Awards";
    public static final String ORGANIZED_OSCAR = "Academy Awards";
    public static final String ORGANIZED_GOLDEN_GLOBE = "Golden Globes";
    public static final String ORGANIZED_BAFTA_FILM_AWARD = "BAFTA Awards";
    public static final String ORGANIZED_BAFTA_TV_AWARD = "BAFTA Awards";
    public static final String ORGANIZED_GOLDEN_LION = "Venice Film Festival";
    public static final String ORGANIZED_GOLDEN_BERLIN_BEAR = "Berlin International Film Festival";
    public static final String ORGANIZED_PALME_DOR = "Cannes Film Festival";
    public static final String ORGANIZED_TEEN_CHOICE_AWARD = "Teen Choice Awards";

    public static boolean isAwardPlaylist(long playlistId) {
        return playlistId >= 100000L && playlistId < (long)AWARD_PLAYLIST_ID_MAX;
    }

    public static String getEventName(EAwardEvent evennt) {
        switch (evennt) {
            case OSCAR: {
                return EVENT_OSCAR;
            }
            case EMMY_AWARDS: {
                return EVENT_EMMY_AWARDS;
            }
            case GOLDEN_GLOBE: {
                return EVENT_GOLDEN_GLOBE;
            }
            case BAFTA_FILM_AWARD: {
                return EVENT_BAFTA_FILM_AWARD;
            }
            case BAFTA_TV_AWARD: {
                return EVENT_BAFTA_TV_AWARD;
            }
            case GOLDEN_LION: {
                return EVENT_GOLDEN_LION;
            }
            case GOLDEN_BERLIN_BEAR: {
                return EVENT_GOLDEN_BERLIN_BEAR;
            }
            case PALME_DOR: {
                return EVENT_PALME_DOR;
            }
            case TEEN_CHOICE_AWARDS: {
                return EVENT_TEEN_CHOICE_AWARD;
            }
        }
        return "";
    }

    public static Set<String> getCategoryByEvent(EAwardEvent evennt) {
        switch (evennt) {
            case OSCAR: {
                return ImmutableSet.builder().add((Object)OSCAR_BEST_FILM).add((Object)OSCAR_BEST_FILM_2005).add((Object)OSCAR_BEST_FILM_1929).add((Object)OSCAR_BEST_FOREIGN_FILM).add((Object)OSCAR_BEST_FOREIGN_FILM_2005).add((Object[])new String[0]).build();
            }
            case GOLDEN_GLOBE: {
                return ImmutableSet.builder().add((Object)GOLDEN_GLOBE_BEST_FILM).add((Object)GOLDEN_GLOBE_BEST_FOREIGN_FILM).build();
            }
            case BAFTA_FILM_AWARD: 
            case BAFTA_TV_AWARD: {
                return ImmutableSet.builder().add((Object)"Best Film").add((Object)BAFTA_BEST_FOREIGN_FILM).build();
            }
            case EMMY_AWARDS: {
                return ImmutableSet.builder().add((Object)EMMY_AWARDS_BEST_SERIES).add((Object)"Outstanding Casting for a Drama Series").add((Object)"Outstanding Comedy Series").add((Object)"Outstanding Casting for a Comedy Series").add((Object)"Outstanding Limited Series").add((Object)"Outstanding Casting for a Limited Series, Movie or Special").add((Object)"Outstanding Television Movie").add((Object)"Outstanding Reality Competition Program").add((Object)"Outstanding Host for a Reality or Reality-Competition Program").add((Object)"Outstanding Variety Sketch Series").add((Object)"Outstanding Structured Reality Program").add((Object)"Outstanding Unstructured Reality Program").add((Object)"Outstanding Documentary or Nonfiction Special").add((Object)"Outstanding Documentary or Nonfiction Series").add((Object)"Outstanding Informational Series or Special").build();
            }
            case GOLDEN_LION: {
                return ImmutableSet.builder().add((Object)"-1").add((Object)"Best Film").build();
            }
            case GOLDEN_BERLIN_BEAR: {
                return ImmutableSet.builder().add((Object)"-1").add((Object)"Best Film").build();
            }
            case PALME_DOR: {
                return ImmutableSet.builder().add((Object)"-1").add((Object)"").build();
            }
            case TEEN_CHOICE_AWARDS: {
                return ImmutableSet.builder().add((Object)TEEN_CHOICE_AWARDS_BEST_FILM).build();
            }
        }
        return Sets.newHashSet();
    }

    public static String getOrganizedByEvent(EAwardEvent evennt) {
        switch (evennt) {
            case OSCAR: {
                return ORGANIZED_OSCAR;
            }
            case EMMY_AWARDS: {
                return ORGANIZED_EMMY_AWARDS;
            }
            case GOLDEN_GLOBE: {
                return ORGANIZED_GOLDEN_GLOBE;
            }
            case BAFTA_FILM_AWARD: {
                return "BAFTA Awards";
            }
            case BAFTA_TV_AWARD: {
                return "BAFTA Awards";
            }
            case GOLDEN_LION: {
                return ORGANIZED_GOLDEN_LION;
            }
            case GOLDEN_BERLIN_BEAR: {
                return ORGANIZED_GOLDEN_BERLIN_BEAR;
            }
            case PALME_DOR: {
                return ORGANIZED_PALME_DOR;
            }
            case TEEN_CHOICE_AWARDS: {
                return ORGANIZED_TEEN_CHOICE_AWARD;
            }
        }
        return "";
    }

    public static String getBackdrop(EAwardEvent evennt) {
        switch (evennt) {
            case OSCAR: {
                return "opt/playlist/oscar-backdrop.jpg";
            }
            case EMMY_AWARDS: {
                return "opt/playlist/emmy_bp.jpg";
            }
            case GOLDEN_GLOBE: {
                return "opt/playlist/golden_globe_backdrop.jpg";
            }
            case BAFTA_FILM_AWARD: {
                return "opt/playlist/bafta_backdrop.jpg";
            }
            case BAFTA_TV_AWARD: {
                return "opt/playlist/bafta_backdrop.jpg";
            }
            case GOLDEN_LION: {
                return "opt/playlist/golden_lion_backup.jpg";
            }
            case GOLDEN_BERLIN_BEAR: {
                return "opt/playlist/bolden_berlin_bear_bcakdrop.jpg";
            }
            case PALME_DOR: {
                return "opt/playlist/palme_dor_cannes_backdrop.jpg";
            }
            case TEEN_CHOICE_AWARDS: {
                return "opt/playlist/awardcenter/TeenChiceAwards_backdrop.png";
            }
        }
        return "";
    }

    public static String getImgTag(EAwardEvent evennt, String position) {
        switch (evennt) {
            case OSCAR: {
                return "opt/playlist/imgtag/award/" + position + "_oscar.png";
            }
            case EMMY_AWARDS: {
                return "opt/playlist/imgtag/award/" + position + "_primetime_emmy.png";
            }
            case GOLDEN_GLOBE: {
                return "opt/playlist/imgtag/award/" + position + "_golden_globe.png";
            }
            case BAFTA_FILM_AWARD: {
                return "opt/playlist/imgtag/award/" + position + "_bafta_film_award.png";
            }
            case BAFTA_TV_AWARD: {
                return "opt/playlist/imgtag/award/" + position + "_bafta_tv_award.png";
            }
            case GOLDEN_LION: {
                return "opt/playlist/imgtag/award/" + position + "_golden_lion.png";
            }
            case GOLDEN_BERLIN_BEAR: {
                return "opt/playlist/imgtag/award/" + position + "_golden_berlin_bear.png";
            }
            case PALME_DOR: {
                return "opt/playlist/imgtag/award/" + position + "_palme_dor.png";
            }
            case TEEN_CHOICE_AWARDS: {
                return "opt/playlist/imgtag/award/" + position + "_teen_choice_award.png";
            }
        }
        return "";
    }

    public static int getPid(EAwardEvent evennt, int year) {
        return 100000 + (evennt.ordinal() * 10000 + year);
    }

    public static EAwardCategory getCategory(EAwardEvent evennt, String category) {
        switch (evennt) {
            case OSCAR: {
                if (OSCAR_BEST_FILM.equalsIgnoreCase(category) || OSCAR_BEST_FILM_2005.equalsIgnoreCase(category) || OSCAR_BEST_FILM_1929.equalsIgnoreCase(category)) {
                    return EAwardCategory.BEST_FILM;
                }
                if (OSCAR_BEST_FOREIGN_FILM.equalsIgnoreCase(category) || OSCAR_BEST_FOREIGN_FILM_2005.equalsIgnoreCase(category)) {
                    return EAwardCategory.BEST_FOREIGN_FILM;
                }
                return EAwardCategory.UNKNOWN;
            }
            case GOLDEN_GLOBE: {
                if (GOLDEN_GLOBE_BEST_FILM.equalsIgnoreCase(category)) {
                    return EAwardCategory.BEST_FILM;
                }
                if (GOLDEN_GLOBE_BEST_FOREIGN_FILM.equalsIgnoreCase(category)) {
                    return EAwardCategory.BEST_FOREIGN_FILM;
                }
                return EAwardCategory.UNKNOWN;
            }
            case BAFTA_FILM_AWARD: 
            case BAFTA_TV_AWARD: {
                if ("Best Film".equalsIgnoreCase(category)) {
                    return EAwardCategory.BEST_FILM;
                }
                if (BAFTA_BEST_FOREIGN_FILM.equalsIgnoreCase(category)) {
                    return EAwardCategory.BEST_FOREIGN_FILM;
                }
                return EAwardCategory.UNKNOWN;
            }
            case GOLDEN_LION: {
                return EAwardCategory.BEST_FILM;
            }
            case GOLDEN_BERLIN_BEAR: {
                return EAwardCategory.BEST_FILM;
            }
            case PALME_DOR: {
                return EAwardCategory.BEST_FILM;
            }
            case TEEN_CHOICE_AWARDS: {
                return EAwardCategory.BEST_DRAMA_FILM;
            }
        }
        return EAwardCategory.UNKNOWN;
    }

    public static String getExtra(EAwardEvent event) {
        return "awardOrder=" + AwardTools.getEventName(event) + "|" + "&imgTagLT=" + AwardTools.getImgTag(event, "lt");
    }

    public static String buildImgTagFilter(EAwardEvent event) {
        return "event:=|" + AwardTools.getEventName(event) + ";" + "category:in|" + Joiner.on((String)"#").skipNulls().join(AwardTools.getCategoryByEvent(event)) + ";" + "won:=|1";
    }

    public static String buildTxtTagFilter(EAwardEvent event) {
        return "event:=|" + AwardTools.getEventName(event) + ";" + "category:in|" + Joiner.on((String)"#").skipNulls().join(AwardTools.getCategoryByEvent(event));
    }
}

