/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.service;

import com.google.common.collect.Maps;
import com.valor.mfc.vms.meta.model.database.dao.MetaDao;
import com.valor.mfc.vms.meta.model.database.ddo.base.Attribute;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AttributeService {
    private static final Logger logger = LoggerFactory.getLogger(AttributeService.class);
    @Autowired
    private MetaDao metaDao;
    private static Map<Long, String> attributeMap = Maps.newConcurrentMap();
    private static Map<String, Long> attributeIdMap = Maps.newConcurrentMap();

    @PostConstruct
    public void loadFromDB() {
        Set values = this.metaDao.getSetData(false, Attribute.class, null);
        if (!values.isEmpty()) {
            values.forEach(e -> {
                attributeMap.put(e.getId(), e.getAttr());
                attributeIdMap.put(e.getAttr(), e.getId());
            });
            logger.info("Load [{}]  attributes from database", (Object)attributeMap.size());
        }
    }

    public String getAttr(long id) {
        return attributeMap.getOrDefault(id, "");
    }

    public long getAttrId(String attr) {
        return attributeIdMap.getOrDefault(attr, -1L);
    }
}

