package com.valor.mfc.vms.meta.model.database.ddo.linked;

import com.valor.mfc.vms.common.database.model.AbstractLMI;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/6/4.
 */
@Entity
@Table(name = "linked_acct",indexes = {
        @Index(name = "idx_linked_acct_userid",columnList = "user_id"),
        @Index(name = "idx_linked_acct_acct",columnList = "site,acct"),
        @Index(name = "idx_linked_acct_site",columnList = "site")}
)
public class LinkedAcctDdo extends AbstractLMI {
    @Id
    @Column(name = "user_id")
    private long userId;

    @Id
    @Column(name="site",length = 16)
    String site;

    @Id
    @Column(name="acct",length = 32)
    String acct;

    @Column(name = "checksum",length = 32)
    private String checksum;

    public long getUserId() {
        return userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getSite() {
        return site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public String getAcct() {
        return acct;
    }

    public void setAcct(String acct) {
        this.acct = acct;
    }

    public String getChecksum() {
        return checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }
}
