package com.valor.mfc.vms.meta.model.database.ddo.cloud;

import com.valor.mfc.vms.api.model.cloud.ECloudSite;
import com.valor.mfc.vms.common.database.model.AbstractLMI;
import com.valor.mfc.vms.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/10/18.
 */
@Entity
@Table(name = "cloud_refresh_strategy")
public class CloudRefreshStrategyDdo extends AbstractLMI{
    /**
    * 为了兼容MM系统,设置自增主键
    */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "sid")
    private long sid;

    @Enumerated(value = EnumType.STRING)
    @Column(name="site",length = 128)
    private ECloudSite site;

    @Column(name="acct_alias",length = 128)
    private String acctAlias = "";

    @Column(name="cycle_refresh")
    private int cycleRefresh = 0;

    @Column(name="refresh_interval")
    private int refreshInterval = 0;

    @Column(name="realtime_refresh")
    private int realtimeRefresh = 0;

    public ECloudSite getSite() {
        return site;
    }

    public void setSite(ECloudSite site) {
        this.site = site;
    }

    public String getAcctAlias() {
        return acctAlias;
    }

    public void setAcctAlias(String acctAlias) {
        this.acctAlias = acctAlias;
    }

    public int getCycleRefresh() {
        return cycleRefresh;
    }

    public void setCycleRefresh(int cycleRefresh) {
        this.cycleRefresh = cycleRefresh;
    }

    public int getRefreshInterval() {
        return refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public int getRealtimeRefresh() {
        return realtimeRefresh;
    }

    public void setRealtimeRefresh(int realtimeRefresh) {
        this.realtimeRefresh = realtimeRefresh;
    }

    public Long getSid() {
        return sid;
    }

    public void setSid(Long sid) {
        this.sid = sid;
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(site,acctAlias);
    }
}
