package com.valor.mfc.vms.meta.model.database.ddo.index;

import com.google.common.base.Objects;
import com.valor.mfc.vms.common.database.model.AbstractLMI;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;

import javax.persistence.*;

/**
 * Created by Frank.Huang on 2016/5/7.
 */
@Entity
@Table(name = "person_index",indexes={@Index(name="imdbIdIndex",columnList="imdb_id"),@Index(name="pcIdIndex",columnList="pc_id")})
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PersonIndex extends AbstractLMI {
    @Id
    @Column(name="vms_id")
    private long vmsId;

    @NaturalId(mutable = true)
    @Column(name="imdb_id",nullable = false, updatable = true, unique = true, length = 16)
    String imdbId;

    @Column(name="tmdb_id")
    private long tmdbId;

    @Column(name = "status")
    private int status;

    @Column(name="pc_id",length = 16)
    String pcId;

    public long getVmsId() {
        return vmsId;
    }

    public void setVmsId(long vmsId) {
        this.vmsId = vmsId;
    }

    public String getImdbId() {
        return imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public long getTmdbId() {
        return tmdbId;
    }

    public void setTmdbId(long tmdbId) {
        this.tmdbId = tmdbId;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getPcId() {
        return pcId;
    }

    public void setPcId(String pcId) {
        this.pcId = pcId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PersonIndex that = (PersonIndex) o;

        return Objects.equal(this.vmsId, that.vmsId) &&
            Objects.equal(this.imdbId, that.imdbId) &&
            Objects.equal(this.pcId, that.pcId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(vmsId, imdbId, pcId);
    }
}
