package com.valor.mfc.vms.meta.model.database.ddo.person;

import com.google.common.base.Objects;

import com.valor.mfc.vms.common.database.model.AbstractLMI;
import com.valor.mfc.vms.common.tools.type.DdoKeyTools;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/5/7.
 */
@Entity
@Table(name = "vms_person_knownfor")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PersonKnowFor extends AbstractLMI {
    @Id
    @Column(name = "person_id")
    public long personId;

    @Id
    @Column(name = "video_id")
    public long videoId;

    public long getPersonId() {
        return personId;
    }

    public void setPersonId(long personId) {
        this.personId = personId;
    }

    public long getVideoId() {
        return videoId;
    }

    public void setVideoId(long videoId) {
        this.videoId = videoId;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PersonKnowFor that = (PersonKnowFor) o;

        return Objects.equal(this.personId, that.personId) &&
                Objects.equal(this.videoId, that.videoId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(personId, videoId);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(personId,videoId);
    }

    @Override
    public boolean valueEquals(Object o) {
        return equals(o);
    }
}
