package com.valor.mfc.vms.meta.model.service;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;


import com.valor.mfc.vms.meta.model.database.dao.MetaDao;
import com.valor.mfc.vms.meta.model.database.ddo.base.Language;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Set;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 * Created by Frank.Huang on 2016/5/14.
 */
@Service("LanguageService")
public class LanguageService {

    private static final Logger logger = LoggerFactory.getLogger(LanguageService.class);

    @Autowired
    private MetaDao metaDao;


    private static Map<String,String> languageMap = Maps.newConcurrentMap();
    private static Map<String,String> codeLangMap = Maps.newConcurrentMap();

    @PostConstruct
    public void loadFromDB(){
        Set<Language> languages = metaDao.getSetData(false,Language.class,null);
        if (!languages.isEmpty()){
            languages.forEach(e->{
                languageMap.put(e.getCode(),e.getName());
                codeLangMap.put(e.getName().toLowerCase(),e.getCode());
            });
            logger.info("Load [{}] languages from database",languages.size());
        }

    }

    @PreDestroy
    public void storeToDB(){
        if (!languageMap.isEmpty()){
            Set<Language> languages = Sets.newHashSet();
            languageMap.forEach((k,v)->{
                Language language = new Language();
                language.setCode(k);
                language.setName(v);
                languages.add(language);
            });

            if (!languages.isEmpty()){
                metaDao.storeAll(languages);
            }
        }
    }


    public String getName(String code){
        return languageMap.getOrDefault(code,"");
    }

    public String getCode(String name){
        return codeLangMap.getOrDefault(name.toLowerCase(),"");
    }
    public void AddLanguages(Map<String,String> languages) {
        if (languages!=null){
            languages.forEach((k,v)->{
                AddLanguage(k,v);
            });
        }
    }

    public void AddLanguage(String code,String name){
        Language language = null;
        String oldName = languageMap.get(code);
        if (Strings.isNullOrEmpty(oldName)){
            language = new Language();
            language.setCode(code);
            language.setName(name);

        }else if (oldName.compareTo(name)!=0){
            language = new Language();
            language.setCode(code);
            language.setName(name);
        }

        languageMap.put(code,name);

        if (language!= null){
            metaDao.storeEntity(language);
        }
    }

}
