package com.valor.mfc.vms.meta.model.service;

import com.google.common.collect.Maps;

import com.valor.mfc.vms.common.tools.type.CollectionUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Created by Frank.Huang on 2016/7/7.
 */
public abstract class AbstractConfigService {
    protected Map<String, String> configMap = Maps.newHashMap();


    public void reload(Map<String,String> configs){
        if (CollectionUtils.isNullOrEmpty(configs)){
            configMap = configs;
        }
    }


    public String getValue(String key){
        return configMap.get(key);
    }

    public String getValue(String key, String defaultValue){
        return configMap.getOrDefault(key,defaultValue);
    }

    public List<String> getValueAsList(String key,String splitter){
        String props = this.getValue(key, "");
        return Arrays.asList(props.split(splitter));
    }

    public boolean getBooleanValue(String key, boolean defaultValue) {
        String value = configMap.get(key);
        if (value != null) {
            return Boolean.parseBoolean(value.trim());
        }
        return defaultValue;
    }

    public int getIntValue(String key, int defaultValue) {
        String value = configMap.get(key);
        if (value != null) {
            try {
                return Integer.parseInt(value.trim());
            } catch (NumberFormatException nfe) {
                // use default value if value is no valid integer
            }
        }
        return defaultValue;
    }

    public long getLongValue(String key, long defaultValue) {
        String value = configMap.get(key);
        if (value != null) {
            try {
                return Long.parseLong(value.trim());
            } catch (NumberFormatException nfe) {
                // use default value if value is no valid long
            }
        }
        return defaultValue;
    }

    /**
     * Return the key properties as a float
     *
     * @param key
     * @param defaultValue
     * @return
     */
    public float getFloatValue(String key, float defaultValue) {
        String value = configMap.get(key);
        if (value != null) {
            try {
                return Float.parseFloat(value.trim());
            } catch (NumberFormatException nfe) {
                // use default value if value is no valid float
            }
        }
        return defaultValue;
    }
}
