package com.valor.mfc.vms.meta.model.database.ddo.configuation;

import com.google.common.base.Objects;

import com.valor.mfc.vms.common.database.model.AbstractLMI;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/7/7.
 */
@MappedSuperclass
public class AbstractConfig extends AbstractLMI {
    @Id
    @Column(name = "config_key", nullable = false, length = 128)
    private String key;

    @Column(name = "config_value", length = 2048)
    private String value;

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractConfig that = (AbstractConfig) o;

        return Objects.equal(this.key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(key);
    }
}
