package com.valor.mfc.vms.meta.model.database.dto;

import com.google.common.collect.Maps;

import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractArtwork;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractMedia;
import com.valor.mfc.vms.meta.model.service.SyncFieldTools;

import java.util.Map;
import java.util.Set;

/**
 * Created by Frank.Huang on 2016/11/27.
 */
public class ImageDto4Merge extends MetaMergeDto {
    private AbstractMedia video;
    private Map<String, AbstractArtwork> artworks = Maps.newHashMap();

    public ImageDto4Merge() {
        super(SyncFieldTools.TYPE_IMG);
    }

    public AbstractMedia getVideo() {
        return video;
    }

    public void setVideo(AbstractMedia video) {
        this.video = video;
        addChanged(video);
    }

    public void setArtworks(Map<String, AbstractArtwork> artworks) {
        this.artworks = artworks;
    }

    public Set<AbstractArtwork> getArtworks() {
        return mapValueAsSet(this.artworks);
    }

    public void setArtworks(Set<AbstractArtwork> artworks) {
        updateArtworkModifyFlag(artworks, modifyFlagWrapper);
        setAll(this.artworks, artworks);
    }

    public void addArtworks(Set<AbstractArtwork> artworks) {
        addAllIfChange(this.artworks, artworks);
    }

    @Override
    public Set<Object> getToBeDelSet() {
        setToBeDel(artworks);
        return super.getToBeDelSet();
    }
}
