/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.database.configuration;

import com.google.common.base.Strings;
import com.valor.mfc.vms.common.database.tool.configruation.AbstractDBCfgWithHikariCP;
import com.valor.mfc.vms.common.tools.type.CollectionUtils;
import common.config.tools.config.ConfigTools2;
import common.config.tools.config.ConfigTools3;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class MetaDBConfiguration
extends AbstractDBCfgWithHikariCP {
    private static final Logger logger = LoggerFactory.getLogger(MetaDBConfiguration.class);
    public static final String DATABASE_MODEL_BASE_PACKAGE = "com.valor.mfc.vms.meta.model";
    private final String aes_key = ConfigTools3.getString((String)"mfc.meta.db.crypt.key");
    private String host = this.getDBConfig("mfc.meta.db.host", this.aes_key);
    private String inst = this.getDBConfig("mfc.meta.db.inst", this.aes_key);
    private String user = this.getDBConfig("mfc.meta.db.user", this.aes_key);
    private String pass = this.getDBConfig("mfc.meta.db.pass", this.aes_key);
    private List<String> appendPackagesToScans = ConfigTools2.getAsList((String)"mfc.meta.db.appendPackagesToScan", (String)",");

    private String getConnectUrl() {
        if (Strings.isNullOrEmpty((String)this.host) || Strings.isNullOrEmpty((String)this.inst) || Strings.isNullOrEmpty((String)this.user) || Strings.isNullOrEmpty((String)this.pass)) {
            logger.error("{}-{}-{}-{}", new Object[]{this.host, this.inst, this.user, this.pass});
            throw new IllegalArgumentException("Invalid parameter");
        }
        return "jdbc:mysql://" + this.host + "/" + this.inst + "?" + "useUnicode=true&characterEncoding=utf8&autoReconnect=true";
    }

    @Primary
    @Bean(destroyMethod="close", name={"metaDataSource"})
    public DataSource metaDataSource() {
        logger.info("Connect database:{}-{}-{}", new Object[]{this.host, this.inst, this.user});
        return this.getDataSource(this.getConnectUrl(), this.user, this.pass);
    }

    @Bean(destroyMethod="destroy", name={"metaSessionFactory"})
    public FactoryBean<SessionFactory> metaSessionFactory() {
        if (CollectionUtils.isNullOrEmpty(this.appendPackagesToScans)) {
            return this.getSessionFactory(this.metaDataSource(), DATABASE_MODEL_BASE_PACKAGE);
        }
        String[] appendPackagesToScanArry = new String[this.appendPackagesToScans.size() + 1];
        for (int i = 0; i < this.appendPackagesToScans.size(); ++i) {
            appendPackagesToScanArry[i] = this.appendPackagesToScans.get(i);
        }
        appendPackagesToScanArry[this.appendPackagesToScans.size()] = DATABASE_MODEL_BASE_PACKAGE;
        return this.getSessionFactory(this.metaDataSource(), appendPackagesToScanArry);
    }

    @Bean(name={"metaTransactionManager"})
    public PlatformTransactionManager metaTransactionManager() throws Exception {
        return this.getTransactionManager((SessionFactory)this.metaSessionFactory().getObject(), 1800);
    }

    public FactoryBean<SessionFactory> getSessionFactory(@Qualifier(value="metaDataSource") DataSource dataSource, String ... scanPackages) {
        return super.getSessionFactory(dataSource, scanPackages);
    }

    public PlatformTransactionManager getTransactionManager(@Qualifier(value="metaSessionFactory") SessionFactory sessionFactory, int txTimeout) throws Exception {
        HibernateTransactionManager transactionManager = new HibernateTransactionManager(sessionFactory);
        transactionManager.setDefaultTimeout(txTimeout);
        return transactionManager;
    }

    public Properties getDBProperties() {
        Properties props = super.getDBProperties();
        this.useL2Cache = ConfigTools3.getBoolean((String)"mfc.meta.db.useL2Cache", (boolean)false);
        logger.info("Use L2 Cache:[{}]", (Object)this.useL2Cache);
        props.put("hibernate.cache.use_second_level_cache", (Object)this.useL2Cache);
        if (this.useL2Cache) {
            props.put("hibernate.cache.region.factory_class", this.l2CacheFactory);
            props.put("hibernate.cache.use_query_cache", (Object)this.useQueryCache);
        }
        props.put("hibernate.hbm2ddl.auto", this.hbm2ddlAuto);
        return props;
    }
}

