/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.database.dto;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.valor.mfc.vms.common.database.model.IComparable;
import com.valor.mfc.vms.meta.model.database.constants.EMetaProperty;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.Video;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoArtwork;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoAttribute;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoAward;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoCastCrew;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoCertification;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoCompany;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoCountry;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoGenre;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoLocale;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoParentsGuide;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoReleaseInfo;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoSimilar;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoSynopsis;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoTitleAKA;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoTrailer;
import com.valor.mfc.vms.meta.model.database.ddo.media.video.VideoUserReview;
import com.valor.mfc.vms.meta.model.database.ddo.person.PersonFilmography2;
import com.valor.mfc.vms.meta.model.database.dto.ArtworkChangedMerge;
import com.valor.mfc.vms.meta.model.database.dto.MetaMergeDto;
import com.valor.mfc.vms.meta.model.database.dto.PersonDto;
import com.valor.mfc.vms.meta.model.database.tools.BitTools;
import common.base.tools.type.CollectionUtils;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class VideoMetaDto4Merge
extends MetaMergeDto {
    private Video video;
    private Map<String, VideoLocale> videoLocales = Maps.newHashMap();
    private Map<String, VideoTrailer> trailers = Maps.newHashMap();
    private Map<String, VideoArtwork> artworks = Maps.newHashMap();
    private Map<String, VideoSynopsis> synopsises = Maps.newHashMap();
    private Map<String, VideoUserReview> userReviews = Maps.newHashMap();
    private Map<String, VideoGenre> genres = Maps.newHashMap();
    private Map<String, VideoCountry> countries = Maps.newHashMap();
    private Map<String, VideoCertification> certs = Maps.newHashMap();
    private Map<String, VideoSimilar> similars = Maps.newHashMap();
    private Map<String, VideoReleaseInfo> releaseInfos = Maps.newHashMap();
    private Map<String, VideoCastCrew> casts = Maps.newHashMap();
    private Map<String, VideoTitleAKA> titleAkas = Maps.newHashMap();
    private Map<String, VideoAward> awards = Maps.newHashMap();
    private Map<String, PersonDto> persons = Maps.newHashMap();
    private Map<String, VideoParentsGuide> parentsGuides = Maps.newHashMap();
    private Map<String, VideoAttribute> attributes = Maps.newHashMap();
    private Map<String, PersonFilmography2> filmographies = Maps.newHashMap();
    private Map<String, VideoCompany> companies = Maps.newHashMap();

    public VideoMetaDto4Merge(String field) {
        super(field);
    }

    public boolean isInvaild() {
        return this.video == null;
    }

    public Video getVideo() {
        return this.video;
    }

    public void setVideo(Video video) {
        this.setVideo(video, false);
    }

    public void setVideo(Video video, boolean update) {
        if (video != null && this.video != null) {
            if (!Strings.isNullOrEmpty((String)this.video.getMetaId())) {
                video.setMetaId(this.video.getMetaId());
            }
            if (this.video.getManual() > 0) {
                video.setManual(this.video.getManual());
            }
            if (this.video.getManual() > 0) {
                video.setManual(this.video.getManual());
            }
            if (BitTools.isSet(this.getVideo().getComplete(), EMetaProperty.META_DUPLICATE.getValue())) {
                video.setComplete(video.getComplete() | EMetaProperty.META_DUPLICATE.getValue());
            }
            if (BitTools.isSet(this.getVideo().getComplete(), EMetaProperty.META_PORNOGRAPHIC.getValue())) {
                video.setComplete(video.getComplete() | EMetaProperty.META_PORNOGRAPHIC.getValue());
            }
        }
        this.video = video;
        if (update) {
            this.meta4QueryWrapper.updateMetaFlag(this.video);
        }
        this.addChanged((Object)video);
    }

    public Set<VideoLocale> getVideoLocales() {
        return this.mapValueAsSet(this.videoLocales);
    }

    public void setVideoLocales(Set<VideoLocale> videoLocales) {
        if (CollectionUtils.isNullOrEmpty(videoLocales)) {
            return;
        }
        Set videoLocaleNoManualedSet = videoLocales.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.valueKey()) && e.getDataVersion() != 99999999999999L).collect(Collectors.toSet());
        this.setAll(this.videoLocales, videoLocaleNoManualedSet);
    }

    public Set<VideoTrailer> getTrailers() {
        return this.mapValueAsSet(this.trailers);
    }

    public void setTrailers(Set<VideoTrailer> trailers) {
        this.setAll(this.trailers, trailers);
    }

    public void addTrailers(Set<VideoTrailer> trailers) {
        this.addAllIfChange(this.trailers, trailers);
    }

    public Set<VideoArtwork> getArtworks() {
        return this.mapValueAsSet(this.artworks);
    }

    public void setArtworks(Set<VideoArtwork> artworks) {
        this.updateArtworkModifyFlag(artworks, this.modifyFlagWrapper);
        this.setAll(this.artworks, artworks);
    }

    public void addArtworks(Set<VideoArtwork> artworks) {
        this.addAllIfChange(this.artworks, artworks, new ArtworkChangedMerge());
        this.meta4QueryWrapper.updateArtworkFlag(artworks, this.modifyFlagWrapper);
    }

    public Set<VideoSynopsis> getSynopsises() {
        return this.mapValueAsSet(this.synopsises);
    }

    public void setSynopsises(Set<VideoSynopsis> synopsises) {
        this.setAll(this.synopsises, synopsises);
    }

    public void addSynopsises(Set<VideoSynopsis> synopsises) {
        this.addAllIfChange(this.synopsises, synopsises);
    }

    public Set<VideoUserReview> getUserReviews() {
        return this.mapValueAsSet(this.userReviews);
    }

    public void setUserReviews(Set<VideoUserReview> userReviews) {
        this.setAll(this.userReviews, userReviews);
    }

    public void addUserReviews(Set<VideoUserReview> userReviews) {
        this.addAllIfChange(this.userReviews, userReviews);
    }

    public Set<VideoGenre> getGenres() {
        return this.mapValueAsSet(this.genres);
    }

    public void setGenres(Set<VideoGenre> genres) {
        this.setAll(this.genres, genres);
    }

    public void addGenres(Set<VideoGenre> genres) {
        this.addAllIfChange(this.genres, genres);
        this.meta4QueryWrapper.updateGenreFlag(genres);
    }

    public Set<VideoCountry> getCountries() {
        return this.mapValueAsSet(this.countries);
    }

    public void setCountries(Set<VideoCountry> countries) {
        this.setAll(this.countries, countries);
        this.meta4QueryWrapper.updateRegionFlag(countries);
    }

    public void addCountries(Set<VideoCountry> countries) {
        this.addAllIfChange(this.countries, countries);
    }

    public Set<VideoCertification> getCerts() {
        return this.mapValueAsSet(this.certs);
    }

    public void setCerts(Set<VideoCertification> certs) {
        this.setAll(this.certs, certs);
    }

    public void addCerts(Set<VideoCertification> certs) {
        this.addAllIfChange(this.certs, certs);
        this.meta4QueryWrapper.updateCertFlag(certs);
    }

    public Set<VideoSimilar> getSimilars() {
        return this.mapValueAsSet(this.similars);
    }

    public void setSimilars(Set<VideoSimilar> similars) {
        this.setAll(this.similars, similars);
    }

    public void addSimilars(Set<VideoSimilar> similars) {
        this.addAllIfChange(this.similars, similars);
    }

    public Set<VideoReleaseInfo> getReleaseInfos() {
        return this.mapValueAsSet(this.releaseInfos);
    }

    public void setReleaseInfos(Set<VideoReleaseInfo> releaseInfos) {
        this.setAll(this.releaseInfos, releaseInfos);
    }

    public void addReleaseInfos(Set<VideoReleaseInfo> releaseInfos) {
        this.addAllIfChange(this.releaseInfos, releaseInfos);
    }

    public Set<VideoCastCrew> getCasts() {
        return this.mapValueAsSet(this.casts);
    }

    public void setCasts(Set<VideoCastCrew> casts) {
        this.setAll(this.casts, casts);
    }

    public void addCasts(Set<VideoCastCrew> casts) {
        this.addAllIfChange(this.casts, casts);
    }

    public Set<PersonDto> getPersons() {
        return Sets.newHashSet(this.persons.values());
    }

    public void setPersons(Set<PersonDto> persons) {
    }

    public Set<VideoTitleAKA> getTitleAkas() {
        return this.mapValueAsSet(this.titleAkas);
    }

    public void setTitleAkas(Set<VideoTitleAKA> titleAkas) {
        this.setAll(this.titleAkas, titleAkas);
    }

    public void addTitleAkas(Set<VideoTitleAKA> titleAkas) {
        this.addAllIfChange(this.titleAkas, titleAkas);
    }

    public Set<VideoAward> getAwards() {
        return this.mapValueAsSet(this.awards);
    }

    public void setAwards(Set<VideoAward> awards) {
        this.setAll(this.awards, awards);
    }

    public void addAwards(Set<VideoAward> awards) {
        this.addAllIfChange(this.awards, awards);
    }

    public Set<VideoParentsGuide> getParentsGuides() {
        return this.mapValueAsSet(this.parentsGuides);
    }

    public void setParentsGuides(Set<VideoParentsGuide> valueSet) {
        this.setAll(this.parentsGuides, valueSet);
    }

    public void addParentsGuides(Set<VideoParentsGuide> valueSet) {
        this.addAllIfChange(this.parentsGuides, valueSet);
    }

    public Set<VideoAttribute> getAttribute() {
        return this.mapValueAsSet(this.attributes);
    }

    public void setAttribute(Set<VideoAttribute> valueSet) {
        this.setAll(this.attributes, valueSet);
    }

    public void addAttribute(Set<VideoAttribute> valueSet) {
        this.addAllIfChange(this.attributes, valueSet);
    }

    public void addAttribute(VideoAttribute v) {
        this.addIfChange(this.attributes, (IComparable)v, null);
    }

    public Set<PersonFilmography2> getFilmographies() {
        return this.mapValueAsSet(this.filmographies);
    }

    public void setFilmographies(Set<PersonFilmography2> filmographies) {
        this.setAll(this.filmographies, filmographies);
    }

    public void addFilmographies(Set<PersonFilmography2> filmographies) {
        this.addAllIfChange(this.filmographies, filmographies);
    }

    public Set<VideoCompany> getCompanies() {
        return this.mapValueAsSet(this.companies);
    }

    public void setCompanies(Set<VideoCompany> companies) {
        this.setAll(this.companies, companies);
    }

    public void addCompanies(Set<VideoCompany> companies) {
        this.addAllIfChange(this.companies, companies);
    }

    @Override
    public Set<Object> getToBeDelSet() {
        this.setToBeDel(this.trailers);
        this.setToBeDel(this.artworks);
        this.setToBeDel(this.genres);
        this.setToBeDel(this.countries);
        this.setToBeDel(this.certs);
        this.setToBeDel(this.similars);
        this.setToBeDel(this.releaseInfos);
        this.setToBeDel(this.casts);
        this.setToBeDel(this.titleAkas);
        this.setToBeDel(this.awards);
        this.setToBeDel(this.parentsGuides);
        this.setToBeDel(this.attributes);
        this.setToBeDel(this.filmographies);
        this.setToBeDel(this.companies);
        return super.getToBeDelSet();
    }
}

