package com.valor.mfc.vms.meta.model.database.dao.query.filter.alias;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;

import com.valor.mfc.vms.common.tools.type.CollectionUtils;
import com.valor.mfc.vms.common.web.request.BaseRequestArgs;

import java.util.List;
import java.util.Map;

/**
 * Created by Frank.Huang on 2016/5/28.
 */
public abstract class SqlQueryAlias {
    public static final String TABLE_META_LINKED = "#{tab_meta_link}";
    public static final String TABLE_META        = "#{tab_meta}";
    public static final String TABLE_COUNTRY     = "#{tab_country}";
    public static final String TABLE_GENRES      = "#{tab_genre}";
    public static final String TFV_MEDIA_TYPE    = "#{tfv_media_type}";

//    public static final long APP_VER_10125 = 10125;
//    public static final String SQL_USER_LINKED_VER_10125_BEFORE = "select distinct(video_id) from linked_meta where user_id=%d";
    //public static final String SQL_USER_LINKED = "select distinct(video_id) from linked_cloud where cid in(select cid from linked_user_cloud where uid=%d)";
public static final String SQL_USER_LINKED = "select distinct(video_id) from linked_cloud where cid in(%s)";
    //public static final String SQL_USER_LINKED_LOCATION_ILLEGAL = "select distinct(video_id) from linked_cloud where cid in(select cid from linked_user_cloud where acct_type != 0 and uid=%d)";


    public Map<String, String> getTableAlias(){
        return Maps.newHashMap();
    }

    public Map<String, String> getFieldAlias(){
        return Maps.newHashMap();
    }

    public Map<String,String> getValueAlias(){
        return Maps.newHashMap();
    }

    public String getBaseTable(int linked) {
        if (linked == 1) {
            return TABLE_META_LINKED;
        } else {
            return TABLE_META;
        }
    }

    public String buildField(int linked,String field){
        if (linked == 1) {
            return TABLE_META_LINKED + "." +field;
        } else {
            return TABLE_META + "." + field;
        }
    }

    public String distinctField(int linked,String f){
        return distinctField(buildField(linked,f));
    }


    public String distinctField(String f){
        return "distinct("+ f +")";
    }

    public String replaceAlias(String sql){
        if (Strings.isNullOrEmpty(sql)){
            return sql;
        }

        sql = replaceAlias(sql,getTableAlias());
        sql = replaceAlias(sql,getFieldAlias());
        sql = replaceAlias(sql,getValueAlias());

        return sql;
    }

    public String replaceAlias(String value,Map<String,String> alias){
        if (Strings.isNullOrEmpty(value)){
            return value;
        }

        if (alias == null || alias.isEmpty()){
            return value;
        }

        for (Map.Entry<String,String> entry:alias.entrySet()){
            value = value.replace(entry.getKey(),entry.getValue());
        }

        return value;
    }

    public static String getUserLinkedSql( List<Long> cids) {
        StringBuilder sb = new StringBuilder();
        if(!CollectionUtils.isNullOrEmpty(cids)){
            int index = 0;
            for (long cid:cids ) {
                sb.append(cid);
                if(index < cids.size()-1){
                    sb.append(",");
                }
                index++;
            }
        }else{
            sb.append("null");
        }
        return String.format(SQL_USER_LINKED,sb.toString());
    }
}
