package com.valor.mfc.vms.meta.model.database.dao.query.filter.filter.converter;

import com.google.common.base.Strings;

import com.valor.mfc.vms.common.tools.type.DateTimeTools;
import com.valor.mfc.vms.meta.model.database.dao.query.filter.filter.IFilterValueConverter;

/**
 * Created by Frank.Huang on 2016/8/17.
 */
public class ReleaseDateConverter implements IFilterValueConverter {
    @Override
    public String converter(String value) {
        if (Strings.isNullOrEmpty(value)){
            return "";
        }

        if (value.startsWith("+") || value.startsWith("-")){
            int diff = Integer.valueOf(value);
            return  String.valueOf(DateTimeTools.distanceTodayInt(diff));
        }else {
            return String.valueOf(DateTimeTools.date2IntVal(value));
        }
    }
}
