package com.valor.mfc.vms.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;

import com.valor.mfc.vms.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/4/28.
 */
@MappedSuperclass
public abstract class AbstractCountry extends AbstractId {
    @Id
    @Column(name="data_id")
    public long dataId;

    public long getDataId() {
        return dataId;
    }

    public void setDataId(long dataId) {
        this.dataId = dataId;
    }

    @Id
    @Column(name = "country_seq",columnDefinition = "int default 0")
    public int countrySeq = 0;

    public int getCountrySeq() {
        return countrySeq;
    }

    public void setCountrySeq(int countrySeq) {
        this.countrySeq = countrySeq;
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id,dataId,countrySeq);
    }

    @Override
    public boolean valueEquals(Object o) {
       return equals(0);
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractCountry that = (AbstractCountry) o;

        return Objects.equal(this.dataId, that.dataId) &&
            Objects.equal(this.id, that.id) &&
            Objects.equal(this.countrySeq, that.countrySeq);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(dataId, id, countrySeq);
    }
}
