package com.valor.mfc.vms.meta.model.database.ddo.media.base;

import com.google.common.base.Objects;

import com.valor.mfc.vms.common.tools.type.DdoKeyTools;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;


/**
 * Created by Frank.Huang on 2016/9/18.
 */
@MappedSuperclass
public class AbstractCriticReviewContent extends AbstractLocaleId {
    @Id
    @Column(name = "review_key",length = 128)
    public String reviewKey;

    @Column(name = "url",length = 1024)
    private String url;

    @Column(name = "type",length = 256)
    private String type;

    @Column(name = "title",length = 1024)
    private String title;

    @Column(name = "text_number")
    private Integer textNumber = 0;

    @Lob
    @Column(name = "text")
    private String text;

    @Lob
    @Column(name = "json")
    private String json;

    @Lob
    @Column(name = "html")
    private String html;

    public String getReviewKey() {
        return reviewKey;
    }

    public void setReviewKey(String reviewKey) {
        this.reviewKey = reviewKey;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getTextNumber() {
        return textNumber;
    }

    public void setTextNumber(Integer textNumber) {
        this.textNumber = textNumber;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getJson() {
        return json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public String getHtml() {
        return html;
    }

    public void setHtml(String html) {
        this.html = html;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractCriticReviewContent that = (AbstractCriticReviewContent) o;

        return Objects.equal(this.reviewKey, that.reviewKey) &&
                Objects.equal(this.language, that.language) &&
                Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(id, language, reviewKey);
    }

    @Override
    public String valueKey() {
        return DdoKeyTools.key(id,language,reviewKey);
    }

    @Override
    public boolean valueEquals(Object o) {
        if (!equals(o)) {
            return false;
        } else {
            AbstractCriticReviewContent that = (AbstractCriticReviewContent) o;

            return Objects.equal(this.url, that.url)
                    && Objects.equal(this.type, that.type)
                    && Objects.equal(this.title, that.title)
                    && Objects.equal(this.textNumber, that.textNumber)
                    && Objects.equal(this.text, that.text)
                    && Objects.equal(this.json, that.json)
                    && Objects.equal(this.html, that.html);
        }
    }
}
