package com.valor.mfc.vms.meta.model.database.ddo.media.tv;

import com.google.common.base.Objects;

import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractSynopsis;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/4/28.
 */
@Entity
@Table(name="vms_tv_series_synopsis")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class TVSeriesSynopsis extends AbstractSynopsis {

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TVSeriesSynopsis that = (TVSeriesSynopsis) o;

        return Objects.equal(this.language, that.language) &&
                Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(language, id);
    }
}
