package com.valor.mfc.vms.meta.model.database.ddo.person;

import com.google.common.base.Objects;

import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractId;
import com.valor.mfc.vms.api.model.constant.JobType;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * Created by Frank.Huang on 2016/5/30.
 */
@MappedSuperclass
public class AbstractPersonMeter extends AbstractId {

    @Column(name = "rank")
    private int rank;

    @Column(name = "imdb_id",length = 16)
    private String imdbId;

    @Column(name = "job_type")
    private JobType jobType;

    @Column(name = "name")
    private String name;

    @Column(name = "photo")
    private String photo;

    public int getRank() {
        return rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public String getImdbId() {
        return imdbId;
    }

    public void setImdbId(String imdbId) {
        this.imdbId = imdbId;
    }

    public JobType getJobType() {
        return jobType;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhoto() {
        return photo;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractPersonMeter that = (AbstractPersonMeter) o;

        return Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(id);
    }
}
