package com.valor.mfc.vms.meta.model.database.tools.media;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;

import com.valor.mfc.vms.common.tools.type.CollectionUtils;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractTitleAKA;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Set;

/**
 * Created by Frank.Huang on 2016/5/16.
 */
public class TitleAkaTools {
    private static final Logger logger = LoggerFactory.getLogger(TitleAkaTools.class);
    private String original;

    private String realCountry = "";
    private String language = "";
    private int workingTitle = 0;


    public TitleAkaTools(String country) {
        this.original = country;
        parse();
    }

    public String getCounrty(){
        return realCountry;
    }

    public String getLanguage(){
        return language;
    }

    public int getWorkingTitle() {
        return workingTitle;
    }

    private void parse(){
        if (Strings.isNullOrEmpty(original)) {
            return;
        }

        int pos = original.indexOf("(");
        if (pos == -1){
            realCountry = original;
            return;
        }

        realCountry = original.substring(0,pos).trim();
        String str= original.substring(pos).replace("(","");

        try {
            List<String> titles = Splitter.on(")").omitEmptyStrings().trimResults().splitToList(str);
            titles.forEach(e->{
                if ("working title".compareToIgnoreCase(e)==0){
                    workingTitle = 1;
                }else if (e.endsWith("title")){
                    language = e.replace("title","").trim();
                }
            });
        }catch (Exception e){
            logger.error("Unkown Title aka. {}", original);
        }
    }


    public static String getTitleAka(String language,String country, Set<AbstractTitleAKA> akas){
        String titleAKA = "";
        if (CollectionUtils.isNullOrEmpty(akas)){
            return "";
        }

        for (AbstractTitleAKA e:akas){
            if (country.equalsIgnoreCase(e.getCountry())){
                if (Strings.isNullOrEmpty(titleAKA)){
                    titleAKA = e.getAka();
                }

                if (language.equalsIgnoreCase(e.getLanguage())){
                    titleAKA = e.getAka();
                }
            }
        }

        return titleAKA;
    }
}
