package com.valor.mfc.vms.meta.model.service;

import com.google.common.collect.Maps;

import com.valor.mfc.vms.meta.model.database.dao.MetaDao;
import com.valor.mfc.vms.meta.model.database.ddo.base.CountryLangDict;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Set;

import javax.annotation.PostConstruct;

/**
 * Created by Frank.Huang on 2016/7/27.
 */
@Service
public class CountryLangService {
    private static final Logger logger = LoggerFactory.getLogger(CountryLangService.class);

    @Autowired private MetaDao metaDao;

    private Map<String, String> langCountryMap = Maps.newHashMap();

    @PostConstruct
    public void load(){
        Set<CountryLangDict> countryLangSet = metaDao.getSetData(false,CountryLangDict.class,null);
        if (!countryLangSet.isEmpty()){
            countryLangSet.forEach(e->{
               langCountryMap.put(e.getLanguageISO9361(),e.getCountryName());
            });

            logger.info("Load [{}] country language from database",langCountryMap.size());
        }
    }


    public String getCountry(String lang){
        return langCountryMap.getOrDefault(lang,"");
    }
}
