package com.valor.mfc.vms.meta.model.util;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import org.apache.commons.codec.language.bm.Lang;

import java.util.Map;

/**
 * Created by Frank.Huang on 2016/4/30.
 */
public class IdentifierUtil {

    public static final long BASE_ID     = 100000000;  //ID基数

    public static final int TYPE_MEDIA  = 1;  //媒体
    public static final int TYPE_MIUSC  = 2;  //音乐
    public static final int TYPE_PERSON = 8;  //人物
    public static final int TYPE_ADULT  = 9;  //成人

    public static final String DISPLAY_PREFIX_MEDIA  = "mm"; //媒体
    public static final String DISPLAY_PREFIX_MIUSC  = "w";  //音乐
    public static final String DISPLAY_PREFIX_PERSON = "mp"; //人物
    public static final String DISPLAY_PREFIX_ADULT  = "aa"; //成人

    protected static ImmutableMap<Integer,String> mapTypePrefix = new ImmutableMap.Builder<Integer,String>()
                                                                .put(TYPE_MEDIA,  DISPLAY_PREFIX_MEDIA)
                                                                .put(TYPE_MIUSC,  DISPLAY_PREFIX_MIUSC)
                                                                .put(TYPE_PERSON, DISPLAY_PREFIX_PERSON)
                                                                .put(TYPE_ADULT,  DISPLAY_PREFIX_ADULT)
                                                                .build();

    protected static ImmutableMap<String,Integer> mapPrefixType = new ImmutableMap.Builder<String,Integer>()
                                                                .put(DISPLAY_PREFIX_MEDIA,  TYPE_MEDIA)
                                                                .put(DISPLAY_PREFIX_MIUSC,  TYPE_MIUSC)
                                                                .put(DISPLAY_PREFIX_PERSON, TYPE_PERSON)
                                                                .put(DISPLAY_PREFIX_ADULT,  TYPE_ADULT)
                                                                .build();

    /**
     * 根据内部id获取展示id
     * @param internalId
     * @return
     */
    public static String getDisplayId(long internalId ){
        int type = (int)(internalId / BASE_ID);
        long sn   = internalId - (type*BASE_ID);

        String prefix = mapTypePrefix.get(type);
//        return Strings.nullToEmpty(prefix)+String.format("%08d",sn);
        return Strings.nullToEmpty(prefix)+Strings.padStart(String.valueOf(sn), 8, '0');
    }

    /**
     * 根据展示id获取内部id
     * @param displayId
     * @return
     */
    public static long getInternalId(String displayId){
        if (Strings.isNullOrEmpty(displayId)){
            return -1;
        }

        int type = 0;
        String snStr = "";

        for (Map.Entry entry : mapPrefixType.entrySet()){
            if (displayId.startsWith((String) entry.getKey())){
                type = (Integer) entry.getValue();
                snStr = displayId.substring(((String) entry.getKey()).length());
                break;
            }
        }

        if (Strings.isNullOrEmpty(snStr)){
            return -1;
        }

        long snnum =0;
        try {
            snnum = Long.valueOf(snStr);
        }catch (NumberFormatException e){
            return -1;
        }

        return type*BASE_ID + snnum;
    }


    public static long getId(int type,long sn){
        return type*BASE_ID + sn;
    }

}
