/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.database.dao.query.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Set;

public class FilterField {
    private String key;
    private String operator;
    private Set<String> values = Sets.newHashSet();

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public void setValues(Set<String> values) {
        this.values = values;
    }

    public void addValue(String value) {
        if (this.isCharacter()) {
            this.values.add("'" + value + "'");
        } else {
            this.values.add(value);
        }
    }

    public boolean isRange() {
        if (Strings.isNullOrEmpty((String)this.operator)) {
            return false;
        }
        return "in".equalsIgnoreCase(this.operator.trim()) || "notin".equalsIgnoreCase(this.operator.trim());
    }

    public boolean isCharacter() {
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[key:");
        stringBuilder.append(this.key);
        stringBuilder.append(" value:");
        stringBuilder.append(Joiner.on((String)" ").join(this.values));
        stringBuilder.append(" operator:");
        stringBuilder.append(this.operator);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.operator, this.values});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterField that = (FilterField)o;
        return Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.operator, (Object)that.operator) && Objects.equal(this.values, that.values);
    }
}

