package com.valor.mfc.vms.meta.model.database.ddo.media;



import com.google.common.base.Objects;
import com.valor.mfc.vms.api.model.constant.EVideoType;
import com.valor.mfc.vms.common.database.model.AbstractLMI;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractId;
import com.valor.mfc.vms.meta.model.database.ddo.media.emum.EMetaEventType;
import common.base.tools.type.DdoKeyTools;

import javax.persistence.*;

/**
 * Created by Frank.Huang on 2016/6/24.
 */
@Entity
@Table(name = "vms_user_rating")
public class UserRatingDdo extends AbstractLMI {


  /*  @Column(name="id")
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long id;
*/
    @Id
    @Column(name = "account_id")
    private long accountId;

    @Id
    @Column(name = "account_type")
    private int accountType;
    @Enumerated(EnumType.ORDINAL)
    @Column(name = "event_type")
    private EMetaEventType metaEventType;

    @Id
    @Column(name = "vms_id")
    private long vmsId;
    @Column(name = "episode_id")
    private long episodeId;
    @Column(name = "meta_id", length = 16)
    private String metaId = "";

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "video_type")
    private EVideoType videoType;

    @Column(name = "did")
    private String did;

    @Column(name = "client_ip")
    private String clientIp;

    @Column(name = "rating")
    int rating = 0;

/*

    public Long getId() {
        return this.getId();
    }

    public void setId(Long id) {
        this.id = id;
    }
*/
    public int getRating() {
        return rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    public long getAccountId() {
        return accountId;
    }

    public void setAccountId(long accountId) {
        this.accountId = accountId;
    }

    public int getAccountType() {
        return accountType;
    }

    public void setAccountType(int accountType) {
        this.accountType = accountType;
    }

    public EMetaEventType getMetaEventType() {
        return metaEventType;
    }

    public void setMetaEventType(EMetaEventType metaEventType) {
        this.metaEventType = metaEventType;
    }

    public long getVmsId() {
        return vmsId;
    }

    public void setVmsId(long vmsId) {
        this.vmsId = vmsId;
    }

    public long getEpisodeId() {
        return episodeId;
    }

    public void setEpisodeId(long episodeId) {
        this.episodeId = episodeId;
    }

    public String getMetaId() {
        return metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public EVideoType getVideoType() {
        return videoType;
    }

    public void setVideoType(EVideoType videoType) {
        this.videoType = videoType;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }
/*
    @Override
    public String valueKey() {
        return DdoKeyTools.key(id);
    }

    @Override
    public boolean valueEquals(Object o) {
        return equals(0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractId that = (AbstractId) o;

        return Objects.equal(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(id);
    }*/
}
