/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.meta.model.database.dao.tools;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.valor.mfc.vms.common.tools.type.CollectionUtils;
import com.valor.mfc.vms.common.tools.type.DateTimeTools;
import com.valor.mfc.vms.meta.model.database.ddo.media.base.AbstractReleaseInfo;
import com.valor.mfc.vms.meta.model.database.ddo.media.emum.EReleaseType;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ReleaseDateTools {
    private Map<String, String> regionDateMap = Maps.newHashMap();
    private String firstReleaseDate = "";
    private int firstReleaseDateInt = Integer.MAX_VALUE;

    public ReleaseDateTools(List relList) {
        if (!CollectionUtils.isNullOrEmpty((Collection)relList)) {
            relList.forEach(e -> {
                if (e instanceof AbstractReleaseInfo) {
                    String sd1;
                    AbstractReleaseInfo releaseInfo = (AbstractReleaseInfo)((Object)((Object)e));
                    int d = DateTimeTools.date2IntVal((String)releaseInfo.getReleaseDate());
                    if (d < this.firstReleaseDateInt) {
                        this.firstReleaseDateInt = d;
                        this.firstReleaseDate = releaseInfo.getReleaseDate();
                    }
                    if (Strings.isNullOrEmpty((String)(sd1 = this.regionDateMap.get(releaseInfo.getCountry().toLowerCase())))) {
                        this.regionDateMap.put(releaseInfo.getCountry().toLowerCase(), releaseInfo.getReleaseDate());
                    } else {
                        int d1 = DateTimeTools.date2IntVal((String)sd1);
                        if (d != 0 && d < d1) {
                            this.regionDateMap.put(releaseInfo.getCountry().toLowerCase(), releaseInfo.getReleaseDate());
                        }
                    }
                }
            });
        }
    }

    public String getFirstReleaseDate() {
        return this.firstReleaseDate;
    }

    public String getRegionReleaseDate(String region) {
        return this.regionDateMap.getOrDefault(region.toLowerCase(), "");
    }

    public static EReleaseType getReleaseDateType(String title) {
        if (Strings.isNullOrEmpty((String)title)) {
            return EReleaseType.THEATRICAL;
        }
        for (EReleaseStrType strType : EReleaseStrType.values()) {
            if (title.indexOf(strType.getValue()) < 0) continue;
            switch (strType) {
                case DEFAULT: {
                    return EReleaseType.THEATRICAL;
                }
                case LIMITED: {
                    return EReleaseType.THEATRICAL_LIMITED;
                }
                case FESTIVAL: {
                    return EReleaseType.FILM_FESTIVAL;
                }
                case PREMIERE: {
                    return EReleaseType.PREMIERE;
                }
                case INTERNET: {
                    return EReleaseType.INTERNET;
                }
                case BLUE_RAY: {
                    return EReleaseType.BLUE_RAY;
                }
                case RE_RELEASE: {
                    return EReleaseType.RE_RELEASE;
                }
                case TV: {
                    return EReleaseType.TV;
                }
            }
        }
        return EReleaseType.OTHER;
    }

    public static String formatENReleaseDate(String releaseDateStr) {
        if (Strings.isNullOrEmpty((String)releaseDateStr)) {
            return "";
        }
        releaseDateStr = releaseDateStr.replace(".", "");
        Date date = null;
        date = releaseDateStr.length() >= 10 ? DateTimeTools.getDateFromLocaleStr((String)releaseDateStr, (String)"dd MMMM yyyy", (Locale)Locale.ENGLISH) : (releaseDateStr.length() > 4 ? DateTimeTools.getDateFromLocaleStr((String)releaseDateStr, (String)"MMMM yyyy", (Locale)Locale.ENGLISH) : DateTimeTools.getDateFromLocaleStr((String)releaseDateStr, (String)"yyyy", (Locale)Locale.ENGLISH));
        if (date == null) {
            return "";
        }
        return DateTimeTools.getDateStr((Date)date, (String)"yyyy-MM-dd", (String)"");
    }

    public static enum EReleaseStrType {
        RE_RELEASE("re-release"),
        DEFAULT("default"),
        PREMIERE("premiere"),
        LIMITED("limited"),
        FESTIVAL("Festival"),
        INTERNET("internet"),
        BLUE_RAY("Blu-ray"),
        TV("TV");

        private String value;

        private EReleaseStrType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

