package com.valor.mfc.vms.user.model.database.config;

import com.google.common.base.Strings;
import com.valor.mfc.vms.common.database.tool.configruation.AbstractDBCfgWithHikariCP;
import common.config.tools.config.ConfigAESTools;
import common.config.tools.config.ConfigTools3;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.sql.DataSource;
import java.util.Properties;

import static java.sql.Connection.TRANSACTION_READ_COMMITTED;

@Configuration
@EnableTransactionManagement
public class UserDBConfiguration extends AbstractDBCfgWithHikariCP {
    private static final Logger LOG = LoggerFactory.getLogger(UserDBConfiguration.class);

    public static final String DATABASE_MODEL_BASE_PACKAGE="com.valor.mfc.vms.user.model";
    //"Ebw6MyVpHAC23ZMszboDDQ"

    private final String crypt_key = ConfigTools3.getString("mfc.user.db.key");
    private String host = getDBConfig("mfc.user.db.host", crypt_key);
    private String dbInst = getDBConfig("mfc.user.db.inst", crypt_key);
    private String username = getDBConfig("mfc.user.db.user", crypt_key);
    private String password = getDBConfig("mfc.user.db.password", crypt_key);

    private String appendPackagesToScan = ConfigTools3.getString("mfc.user.db.appendPackage");

    

    private String getConnectUrl(){
        if (Strings.isNullOrEmpty(host)
            || Strings.isNullOrEmpty(dbInst)
            || Strings.isNullOrEmpty(username)
            || Strings.isNullOrEmpty(password)){
            //LOG.error("{}-{}-{}-{}",host,dbInst,username,password);
            throw new IllegalArgumentException("Invalid parameter");
        }

        return new StringBuilder()
                .append("jdbc:mysql://")
                .append(host).append("/")
                .append(dbInst)
                .append("?")
                .append("useUnicode=true&characterEncoding=utf8&autoReconnect=true")
                .toString();
    }

    //@Primary
    @Bean(destroyMethod="close",name = "userDataSource")
    public DataSource userDataSource() {
        LOG.info("Connect database:{}:{}:{}",host,dbInst,username);
        return getDataSource(getConnectUrl(),username, password);
    }


    @Bean(destroyMethod="destroy",name = "userSessionFactory")
    @Qualifier(value = "userSessionFactory")
    public FactoryBean<SessionFactory> userSessionFactory() {
        if (Strings.isNullOrEmpty(appendPackagesToScan)){
            return getSessionFactory(userDataSource(), DATABASE_MODEL_BASE_PACKAGE);
        }else {
            return getSessionFactory(userDataSource(), DATABASE_MODEL_BASE_PACKAGE,appendPackagesToScan);
        }
    }

    @Bean(name = "userTransactionManager")
    @Qualifier(value = "userTransactionManager")
    public PlatformTransactionManager metaTransactionManager() throws Exception {
       return getTransactionManager(userSessionFactory().getObject(), 1800);
    }
    

    @Override
    public Properties getDBProperties() {
        Properties props = new Properties();
        props.put("hibernate.dialect", dialect);
        props.put("hibernate.show_sql", showSql);
        props.put("hibernate.generate_statistics", generateStatistics);
        props.put("hibernate.hbm2ddl.auto", hbm2ddlAuto);
        props.put("hibernate.connection.isolation", TRANSACTION_READ_COMMITTED);
        props.put("hibernate.use_sql_comments", true);


        props.put("hibernate.connection.CharSet", "utf8");
        props.put("hibernate.connection.characterEncoding", "utf8");
        props.put("hibernate.connection.useUnicode", false);
        props.put("hibernate.autoReconnect", true);

        props.put("hibernate.cache.use_second_level_cache", false);
        props.put("hibernate.cache.use_query_cache", false);

        return props;
    }

    @Override
    public FactoryBean<SessionFactory> getSessionFactory(@Qualifier("userDataSource") DataSource dataSource, String... scanPackages) {
        return super.getSessionFactory(dataSource, scanPackages);
    }

    @Override
    public PlatformTransactionManager getTransactionManager(@Qualifier("userSessionFactory") SessionFactory sessionFactory, int txTimeout) throws Exception {
        return super.getTransactionManager(sessionFactory, txTimeout);
    }
}

