package com.valor.mfc.vms.user.model.database.ddo;


import com.valor.mfc.vms.common.database.model.AbstractLMI;

import javax.persistence.*;
import java.io.Serializable;

@Entity
@Table(name = "mfc_sub_account")
public class SubAccountDdo extends AbstractLMI implements Serializable {

    private static final long serialVersionUID = -6141890495300908387L;

    @Id
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "subAccountGenerator")
    @TableGenerator(name = "subAccountGenerator", initialValue = 10000000, allocationSize = 1)
    @Column(name = "sub_account_id",
        length = 128)
    private Long subAccountId;

    @Id
    @Column(name = "account_id",
        length = 64)
    private Long accountId;

    @Column(name = "sub_account_name",
        length = 64)
    private String subAccountName;

    @Column(name = "did",
        // unique = true,
        length = 128
    )
    private String did;

    @Column(name = "status",
        length = 10)
    private Integer status = 0;

    @Column(name = "is_master",
        length = 2)
    private boolean isMaster;

    @Column(name = "sort_no",
        length = 64)
    private Long sortNo;

    @Column(name = "account_type")
    private Integer accountType;

    @Column(name = "property", columnDefinition = "bigint(11) default 0")
    private Long property = 0L;

    @Column(name = "migrated_id", columnDefinition = "bigint(11) default -1")
    private Long migratedId = -1L;

    @Column(name = "migrated_account_id", columnDefinition = "bigint(11) default -1")
    private Long migratedAccountId = -1L;

    public Long getSubAccountId() {
        return subAccountId;
    }

    public void setSubAccountId(Long subAccountId) {
        this.subAccountId = subAccountId;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getSubAccountName() {
        return subAccountName;
    }

    public void setSubAccountName(String subAccountName) {
        this.subAccountName = subAccountName;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public boolean isMaster() {
        return isMaster;
    }

    public void setMaster(boolean master) {
        isMaster = master;
    }

    public Long getSortNo() {
        return sortNo;
    }

    public void setSortNo(Long sortNo) {
        this.sortNo = sortNo;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Long getProperty() {
        return property;
    }

    public void setProperty(Long property) {
        this.property = property;
    }

    public Long getMigratedId() {
        return migratedId;
    }

    public void setMigratedId(Long migratedId) {
        this.migratedId = migratedId;
    }

    public Long getMigratedAccountId() {
        return migratedAccountId;
    }

    public void setMigratedAccountId(Long migratedAccountId) {
        this.migratedAccountId = migratedAccountId;
    }
}
