package com.valor.mfc.vms.user.model.database.ddo;

import com.valor.mfc.vms.api.model.user.EAccountType;
import com.valor.mfc.vms.api.model.user.EUserGroup;
import com.valor.mfc.vms.common.database.model.AbstractLMI;

import javax.persistence.*;
import java.util.Date;

/**
 * File        : Description : Author      : Frank Created     : 2015/9/29
 */
@Entity
@Table(name = "vms_user_task")
public class UserTaskDdo extends AbstractLMI {

    public enum UserTaskType {
        MIGRATE, ADD_CLOUD,EMAIL_BIND_MIGRATE_PROFILE_DATA,EMAIL_BIND_MIGRATE_CLOUD_DATA,EMAIL_BIND_UPDATE_BIZ_DATE
    }

    public enum UserTaskStatus {
        CREATED, FINISHED
    }

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Long id;

    @Column(name = "props", columnDefinition = "bigint default 0")
    private Long props = 0L;

    @Column(name = "type")
    private int type;

    @Column(name = "params", length = 500)
    private String params;

    @Column(name = "accountId")
    private Long accountId;

    @Column(name = "accountType")
    private int accountType;

    @Column(name = "status")
    private int status = UserTaskStatus.CREATED.ordinal();

    @Column(name = "retryTimes",columnDefinition = "int default 0")
    private int retryTimes = 0;


    public int getRetryTimes() {
        return retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getProps() {
        return props;
    }

    public void setProps(Long props) {
        this.props = props;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getParams() {
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public int getAccountType() {
        return accountType;
    }

    public void setAccountType(int accountType) {
        this.accountType = accountType;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}
