package com.valor.mfc.vms.user.model.database.ddo.perferences;

import com.valor.mfc.vms.user.model.database.ddo.common.AbstractUID;

import java.util.Objects;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Created by Frank.Huang on 2016/7/14.
 */
@Entity
@Table(name = "vms_user_preferences")
public class UserPreferencesDdo extends AbstractUID {
    @Id
    @Column(name = "config_key")
    private String key;

    @Column(name = "config_value",length = 2048)
    private String value;

    @Id
    @Column(name = "type")
    private Integer type=0;

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserPreferencesDdo that = (UserPreferencesDdo) o;
        return Objects.equals(key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key);
    }
}
