package com.valor.mfc.vms.user.model.tools;

import com.valor.mfc.vms.api.model.tools.UserPropImmutableTools;
import com.valor.mfc.vms.api.model.user.EUserProps;

/**
 * Created by Frank.Huang on 2016/12/10.
 */
public class UserPropMutableTools extends UserPropImmutableTools {

    public UserPropMutableTools(long userProps) {
        super(userProps);
    }

    public void setProp(EUserProps up) {
        props = props | up.getValue();
    }

    public void clsProp(EUserProps up) {
        props = (props & (~(up.getValue())));
    }


    public void setTest() {
        setProp(EUserProps.TEST);
    }

    public void setStandalone() {
        setProp(EUserProps.STANDALONE);
    }

    public void setBizPlayBase() {
        setProp(EUserProps.PLAY_ALLOWED);
    }

    public void clsBizPlayBase() {
        clsProp(EUserProps.PLAY_ALLOWED);
    }

    public void setLocationIllegal() {
        if (!isSet(EUserProps.LOCATION_UNLIMITED)) {
            setProp(EUserProps.LOCATION_ILLEGAL);
        }
    }

    public void clsLocationIllegal() {
        clsProp(EUserProps.LOCATION_ILLEGAL);
    }

    public void setFreeToMembership() {
        if (!isSet(EUserProps.FREE_TO_MEMBERSHIP)) {
            setProp(EUserProps.FREE_TO_MEMBERSHIP);
        }
    }

    public void clsFreeToMembership() {
        clsProp(EUserProps.FREE_TO_MEMBERSHIP);
    }

    public void setMigrateData() {
        if (!isSet(EUserProps.MIGRATED_DATA)) {
            setProp(EUserProps.MIGRATED_DATA);
        }
    }

    public void clsMigrateData() {
        clsProp(EUserProps.MIGRATED_DATA);
    }

}
