/*
 * Decompiled with CFR 0.152.
 */
package com.valor.mfc.vms.user.model.database.config;

import com.google.common.base.Strings;
import com.valor.mfc.vms.common.database.tool.configruation.AbstractDBCfgWithHikariCP;
import common.config.tools.config.ConfigTools3;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class UserDBConfiguration
extends AbstractDBCfgWithHikariCP {
    private static final Logger LOG = LoggerFactory.getLogger(UserDBConfiguration.class);
    public static final String DATABASE_MODEL_BASE_PACKAGE = "com.valor.mfc.vms.user.model";
    private final String crypt_key = ConfigTools3.getString((String)"mfc.user.db.key");
    private String host = this.getDBConfig("mfc.user.db.host", this.crypt_key);
    private String dbInst = this.getDBConfig("mfc.user.db.inst", this.crypt_key);
    private String username = this.getDBConfig("mfc.user.db.user", this.crypt_key);
    private String password = this.getDBConfig("mfc.user.db.password", this.crypt_key);
    private String appendPackagesToScan = ConfigTools3.getString((String)"mfc.user.db.appendPackage");

    private String getConnectUrl() {
        if (Strings.isNullOrEmpty((String)this.host) || Strings.isNullOrEmpty((String)this.dbInst) || Strings.isNullOrEmpty((String)this.username) || Strings.isNullOrEmpty((String)this.password)) {
            throw new IllegalArgumentException("Invalid parameter");
        }
        return "jdbc:mysql://" + this.host + "/" + this.dbInst + "?" + "useUnicode=true&characterEncoding=utf8&autoReconnect=true";
    }

    @Bean(destroyMethod="close", name={"userDataSource"})
    public DataSource userDataSource() {
        LOG.info("Connect database:{}:{}:{}", new Object[]{this.host, this.dbInst, this.username});
        return this.getDataSource(this.getConnectUrl(), this.username, this.password);
    }

    @Bean(destroyMethod="destroy", name={"userSessionFactory"})
    @Qualifier(value="userSessionFactory")
    public FactoryBean<SessionFactory> userSessionFactory() {
        if (Strings.isNullOrEmpty((String)this.appendPackagesToScan)) {
            return this.getSessionFactory(this.userDataSource(), DATABASE_MODEL_BASE_PACKAGE);
        }
        return this.getSessionFactory(this.userDataSource(), DATABASE_MODEL_BASE_PACKAGE, this.appendPackagesToScan);
    }

    @Bean(name={"userTransactionManager"})
    @Qualifier(value="userTransactionManager")
    public PlatformTransactionManager metaTransactionManager() throws Exception {
        return this.getTransactionManager((SessionFactory)this.userSessionFactory().getObject(), 1800);
    }

    public Properties getDBProperties() {
        Properties props = new Properties();
        props.put("hibernate.dialect", this.dialect);
        props.put("hibernate.show_sql", (Object)this.showSql);
        props.put("hibernate.generate_statistics", (Object)this.generateStatistics);
        props.put("hibernate.hbm2ddl.auto", this.hbm2ddlAuto);
        props.put("hibernate.connection.isolation", (Object)2);
        props.put("hibernate.use_sql_comments", (Object)true);
        props.put("hibernate.connection.CharSet", "utf8");
        props.put("hibernate.connection.characterEncoding", "utf8");
        props.put("hibernate.connection.useUnicode", (Object)false);
        props.put("hibernate.autoReconnect", (Object)true);
        props.put("hibernate.cache.use_second_level_cache", (Object)false);
        props.put("hibernate.cache.use_query_cache", (Object)false);
        return props;
    }

    public FactoryBean<SessionFactory> getSessionFactory(@Qualifier(value="userDataSource") DataSource dataSource, String ... scanPackages) {
        return super.getSessionFactory(dataSource, scanPackages);
    }

    public PlatformTransactionManager getTransactionManager(@Qualifier(value="userSessionFactory") SessionFactory sessionFactory, int txTimeout) throws Exception {
        return super.getTransactionManager(sessionFactory, txTimeout);
    }
}

