/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.guava;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.guava.CaffeinatedGuavaCache;
import com.github.benmanes.caffeine.guava.CaffeinatedGuavaLoadingCache;
import com.google.common.cache.Cache;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CaffeinatedGuava {
    private CaffeinatedGuava() {
    }

    public static <K, V, K1 extends K, V1 extends V> @NonNull Cache<K1, V1> build(@NonNull Caffeine<K, V> builder) {
        return new CaffeinatedGuavaCache(builder.build());
    }

    public static <K, V, K1 extends K, V1 extends V> @NonNull LoadingCache<K1, V1> build(@NonNull Caffeine<K, V> builder, @NonNull com.google.common.cache.CacheLoader<? super K1, V1> loader) {
        com.google.common.cache.CacheLoader<? super K1, V1> castedLoader = loader;
        return CaffeinatedGuava.build(builder, CaffeinatedGuava.hasLoadAll(castedLoader) ? new CaffeinatedGuavaLoadingCache.BulkLoader<K1, V1>(castedLoader) : new CaffeinatedGuavaLoadingCache.SingleLoader<K1, V1>(castedLoader));
    }

    public static <K, V, K1 extends K, V1 extends V> @NonNull LoadingCache<K1, V1> build(@NonNull Caffeine<K, V> builder, @NonNull CacheLoader<? super K1, V1> loader) {
        return new CaffeinatedGuavaLoadingCache<K1, V1>(builder.build(loader));
    }

    static boolean hasLoadAll(com.google.common.cache.CacheLoader<?, ?> cacheLoader) {
        return CaffeinatedGuava.hasMethod(cacheLoader, "loadAll", Iterable.class);
    }

    static boolean hasMethod(com.google.common.cache.CacheLoader<?, ?> cacheLoader, String name, Class<?> ... paramTypes) {
        try {
            Method method = cacheLoader.getClass().getMethod(name, paramTypes);
            return method.getDeclaringClass() != com.google.common.cache.CacheLoader.class;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }
}

