/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;

public class KeyUtils {
    public static final ByteString ZERO_BYTE = KeyUtils.singleByte(0);
    private static final String HEX_CHARS_STR = "0123456789abcdef";
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    private KeyUtils() {
    }

    public static ByteString plusOne(ByteString key) {
        int max = key.size() - 1;
        if (max < 0) {
            return KeyUtils.singleByte(1);
        }
        int lastPlusOne = key.byteAt(max) + 1;
        ByteString excludeLast = key.substring(0, max);
        return lastPlusOne == 0 ? KeyUtils.plusOne(excludeLast) : excludeLast.concat(KeyUtils.singleByte(lastPlusOne));
    }

    public static ByteString singleByte(int b) {
        return UnsafeByteOperations.unsafeWrap(new byte[]{(byte)b});
    }

    public static int compareByteStrings(ByteString bs1, ByteString bs2) {
        int s1 = bs1.size();
        int s2 = bs2.size();
        int n = Math.min(s1, s2);
        for (int i = 0; i < n; ++i) {
            int cmp = (bs1.byteAt(i) & 0xFF) - (bs2.byteAt(i) & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        return s1 - s2;
    }

    public static ByteString bs(String str) {
        return str != null ? ByteString.copyFromUtf8(str) : null;
    }

    public static String toHexString(ByteString bs) {
        int len = bs.size();
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(len << 1);
        for (int i = 0; i < len; ++i) {
            byte b = bs.byteAt(i);
            sb.append(HEX_CHARS[b >> 4 & 0xF]).append(HEX_CHARS[b & 0xF]);
        }
        return sb.toString();
    }

    public static ByteString fromHexString(CharSequence seq) {
        int len = seq.length();
        if (len == 0) {
            return ByteString.EMPTY;
        }
        if (len % 2 != 0) {
            throw new IllegalArgumentException("must be even number of chars");
        }
        int blen = len >> 1;
        byte[] bytes = new byte[blen];
        int i = 0;
        int j = 0;
        while (i < blen) {
            bytes[i] = (byte)(KeyUtils.digitFor(seq.charAt(j)) << 4 | KeyUtils.digitFor(seq.charAt(j + 1)));
            ++i;
            j += 2;
        }
        return UnsafeByteOperations.unsafeWrap(bytes);
    }

    private static int digitFor(char c) {
        int d = HEX_CHARS_STR.indexOf(Character.toLowerCase(c));
        if (d == -1) {
            throw new IllegalArgumentException("invalid char: " + c);
        }
        return d;
    }
}

