/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etcd.client.lock;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.ibm.etcd.api.LockGrpc;
import com.ibm.etcd.api.LockRequest;
import com.ibm.etcd.api.LockResponse;
import com.ibm.etcd.api.UnlockRequest;
import com.ibm.etcd.api.UnlockResponse;
import com.ibm.etcd.client.EtcdClient;
import com.ibm.etcd.client.FluentRequest;
import com.ibm.etcd.client.GrpcClient;
import com.ibm.etcd.client.lease.PersistentLease;
import com.ibm.etcd.client.lock.LockClient;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class EtcdLockClient
implements LockClient {
    private static final MethodDescriptor<LockRequest, LockResponse> METHOD_LOCK = LockGrpc.getLockMethod();
    private static final MethodDescriptor<UnlockRequest, UnlockResponse> METHOD_UNLOCK = LockGrpc.getUnlockMethod();
    protected final EtcdClient etcdClient;
    protected final GrpcClient grpcClient;

    public EtcdLockClient(GrpcClient grpcClient, EtcdClient etcdClient) {
        this.grpcClient = grpcClient;
        this.etcdClient = etcdClient;
    }

    @Override
    public LockClient.FluentLockRequest lock(ByteString name) {
        return new EtcdLockRequest(name);
    }

    @Override
    public LockClient.FluentUnlockRequest unlock(ByteString key) {
        return new EtcdUnlockRequest(key);
    }

    final class EtcdUnlockRequest
    extends FluentRequest.AbstractFluentRequest<LockClient.FluentUnlockRequest, UnlockRequest, UnlockResponse, UnlockRequest.Builder>
    implements LockClient.FluentUnlockRequest {
        EtcdUnlockRequest(ByteString key) {
            super(EtcdLockClient.this.grpcClient, UnlockRequest.newBuilder().setKey(key));
        }

        @Override
        protected MethodDescriptor<UnlockRequest, UnlockResponse> getMethod() {
            return METHOD_UNLOCK;
        }

        @Override
        protected boolean idempotent() {
            return true;
        }
    }

    final class EtcdLockRequest
    extends FluentRequest.AbstractFluentRequest<LockClient.FluentLockRequest, LockRequest, LockResponse, LockRequest.Builder>
    implements LockClient.FluentLockRequest {
        PersistentLease lease;

        EtcdLockRequest(ByteString name) {
            super(EtcdLockClient.this.grpcClient, LockRequest.newBuilder().setName(name));
        }

        @Override
        protected MethodDescriptor<LockRequest, LockResponse> getMethod() {
            return METHOD_LOCK;
        }

        @Override
        protected boolean idempotent() {
            return true;
        }

        @Override
        public LockClient.FluentLockRequest withLease(long leaseId) {
            ((LockRequest.Builder)this.builder).setLease(leaseId);
            this.lease = null;
            return this;
        }

        @Override
        public LockClient.FluentLockRequest withLease(PersistentLease lease) {
            this.lease = lease;
            return this;
        }

        @Override
        public final ListenableFuture<LockResponse> async(Executor executor) {
            ListenableFuture<Long> fut;
            long plId;
            if (this.lease == null) {
                if (((LockRequest.Builder)this.builder).getLease() != 0L) {
                    return super.async(executor);
                }
                this.lease = EtcdLockClient.this.etcdClient.getSessionLease();
            }
            if ((plId = this.lease.getLeaseId()) != 0L) {
                ((LockRequest.Builder)this.builder).setLease(plId);
                return super.async(executor);
            }
            if (this.deadline == null) {
                fut = this.lease;
            } else {
                long remainingNanos = this.deadline.timeRemaining(TimeUnit.NANOSECONDS);
                fut = Futures.catching(Futures.withTimeout(this.lease, remainingNanos, TimeUnit.NANOSECONDS, EtcdLockClient.this.grpcClient.getInternalExecutor()), TimeoutException.class, te -> {
                    throw Status.DEADLINE_EXCEEDED.withCause((Throwable)te).withDescription(String.format("deadline exceeded after %dns", remainingNanos)).asRuntimeException();
                }, MoreExecutors.directExecutor());
            }
            return Futures.transformAsync(fut, id -> {
                ((LockRequest.Builder)this.builder).setLease((long)id);
                return super.async(executor);
            }, executor);
        }
    }
}

