/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.client;

import com.valor.vod.hotkey.client.Context;
import com.valor.vod.hotkey.client.callback.ReceiveNewKeySubscribe;
import com.valor.vod.hotkey.client.configcenter.ConfigCenterFactory;
import com.valor.vod.hotkey.client.configcenter.ConfigCenterStarter;
import com.valor.vod.hotkey.client.core.eventbus.EventBusCenter;
import com.valor.vod.hotkey.client.core.key.PushSchedulerStarter;
import com.valor.vod.hotkey.client.core.rule.KeyRuleHolder;
import com.valor.vod.hotkey.client.core.worker.WorkerChangeSubscriber;
import com.valor.vod.hotkey.client.core.worker.WorkerRetryConnector;
import com.valor.vod.hotkey.common.configcenter.ConfigCenterCfg;
import com.valor.vod.hotkey.common.tool.NamedThreadFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientStarter {
    private static final Logger logger = LoggerFactory.getLogger(ClientStarter.class);
    private String etcdServer;
    private Long pushPeriod;
    private int caffeineSize;
    private ConfigCenterCfg configCenterCfg;

    public ClientStarter(String appName) {
        if (appName == null) {
            throw new NullPointerException("APP_NAME cannot be null!");
        }
        Context.APP_NAME = appName;
    }

    public void setConfigCenterCfg(ConfigCenterCfg configCenterCfg) {
        this.configCenterCfg = configCenterCfg;
    }

    public void startPipeline() {
        Context.CAFFEINE_SIZE = this.caffeineSize;
        ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(4, new NamedThreadFactory("hotkey-client-executor-", true));
        PushSchedulerStarter pushSchedulerStarter = new PushSchedulerStarter(scheduledExecutor);
        pushSchedulerStarter.startPusher(this.pushPeriod);
        pushSchedulerStarter.startCountPusher(10);
        WorkerRetryConnector workerRetryConnector = new WorkerRetryConnector(scheduledExecutor);
        workerRetryConnector.retryConnectWorkers();
        this.registerEventBus();
        this.retryConnectConfigCenter(0L, 0, scheduledExecutor);
    }

    private void retryConnectConfigCenter(long delay, int retry, ScheduledExecutorService scheduledExecutor) {
        scheduledExecutor.schedule(() -> {
            try {
                if (this.configCenterCfg != null) {
                    ConfigCenterFactory.buildConfigCenter(this.configCenterCfg);
                } else {
                    ConfigCenterFactory.buildConfigCenter(this.etcdServer);
                }
            }
            catch (Throwable e) {
                logger.error("ConfigCenter unconnected. retry:{}", (Object)retry, (Object)e);
                this.retryConnectConfigCenter(10000L, retry + 1, scheduledExecutor);
                return;
            }
            ConfigCenterStarter configCenterStarter = new ConfigCenterStarter(scheduledExecutor);
            configCenterStarter.start();
        }, delay, TimeUnit.MILLISECONDS);
    }

    private void registerEventBus() {
        EventBusCenter.register(new WorkerChangeSubscriber());
        EventBusCenter.register(new ReceiveNewKeySubscribe());
        EventBusCenter.register(new KeyRuleHolder());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String appName;
        private String etcdServer;
        private Long pushPeriod;
        private int caffeineSize = 200000;
        private ConfigCenterCfg configCenterCfg;

        public Builder setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder setCaffeineSize(int caffeineSize) {
            if (caffeineSize < 128) {
                caffeineSize = 128;
            }
            this.caffeineSize = caffeineSize;
            return this;
        }

        public Builder setEtcdServer(String etcdServer) {
            this.etcdServer = etcdServer;
            return this;
        }

        public Builder setPushPeriod(Long pushPeriod) {
            this.pushPeriod = pushPeriod;
            return this;
        }

        public Builder setConfigCenterCfg(ConfigCenterCfg configCenterCfg) {
            this.configCenterCfg = configCenterCfg;
            return this;
        }

        public ClientStarter build() {
            ClientStarter clientStarter = new ClientStarter(this.appName);
            clientStarter.pushPeriod = this.pushPeriod;
            clientStarter.caffeineSize = this.caffeineSize;
            clientStarter.etcdServer = this.etcdServer;
            clientStarter.configCenterCfg = this.configCenterCfg;
            return clientStarter;
        }
    }
}

