/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.client.callback;

import com.valor.vod.hotkey.client.cache.CacheFactory;
import com.valor.vod.hotkey.client.callback.HotKeyStore;
import com.valor.vod.hotkey.client.callback.ReceiveNewKeyListener;
import com.valor.vod.hotkey.client.callback.ValueModel;
import com.valor.vod.hotkey.client.log.JdLogger;
import com.valor.vod.hotkey.common.model.HotKeyModel;

public class DefaultNewKeyListener
implements ReceiveNewKeyListener {
    @Override
    public void newKey(HotKeyModel hotKeyModel) {
        long now = System.currentTimeMillis();
        if (hotKeyModel.getCreateTime() != 0L && Math.abs(now - hotKeyModel.getCreateTime()) > 1000L) {
            JdLogger.warn(this.getClass(), "the key comes too late : " + hotKeyModel.getKey() + " now " + now + " keyCreateAt " + hotKeyModel.getCreateTime());
        }
        if (hotKeyModel.isRemove()) {
            this.deleteKey(hotKeyModel.getKey());
            return;
        }
        if (HotKeyStore.isHot(hotKeyModel.getKey())) {
            JdLogger.warn(this.getClass(), "receive repeat hot key \uff1a" + hotKeyModel.getKey() + " at " + now);
        }
        this.addKey(hotKeyModel.getKey());
    }

    private void addKey(String key) {
        ValueModel valueModel = ValueModel.defaultValue(key);
        if (valueModel == null) {
            this.deleteKey(key);
            return;
        }
        HotKeyStore.setValueDirectly(key, valueModel);
    }

    private void deleteKey(String key) {
        CacheFactory.getNonNullCache(key).delete(key);
    }
}

