/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.client.callback;

import com.valor.vod.hotkey.client.cache.CacheFactory;
import com.valor.vod.hotkey.client.cache.LocalCache;
import com.valor.vod.hotkey.client.callback.ValueModel;
import com.valor.vod.hotkey.client.core.key.HotKeyPusher;
import com.valor.vod.hotkey.client.core.key.KeyHandlerFactory;
import com.valor.vod.hotkey.client.core.key.KeyHotModel;
import com.valor.vod.hotkey.common.model.typeenum.KeyType;
import com.valor.vod.hotkey.common.tool.Constant;

public class HotKeyStore {
    private static boolean isNearExpire(ValueModel valueModel) {
        if (valueModel == null) {
            return true;
        }
        return valueModel.getCreateTime() + (long)valueModel.getDuration() - System.currentTimeMillis() <= 2000L;
    }

    public static boolean isHotKey(String key) {
        try {
            if (!HotKeyStore.inRule(key)) {
                return false;
            }
            boolean isHot = HotKeyStore.isHot(key);
            if (!isHot) {
                HotKeyPusher.push(key, null);
            } else {
                ValueModel valueModel = HotKeyStore.getValueSimple(key);
                if (HotKeyStore.isNearExpire(valueModel)) {
                    HotKeyPusher.push(key, null);
                }
            }
            KeyHandlerFactory.getCounter().collect(new KeyHotModel(key, isHot));
            return isHot;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object get(String key) {
        ValueModel value = HotKeyStore.getValueSimple(key);
        if (value == null) {
            return null;
        }
        Object object = value.getValue();
        if (object instanceof Integer && Constant.MAGIC_NUMBER == (Integer)object) {
            return null;
        }
        return object;
    }

    public static void smartSet(String key, Object value) {
        if (HotKeyStore.isHot(key)) {
            ValueModel valueModel = HotKeyStore.getValueSimple(key);
            if (valueModel == null) {
                return;
            }
            valueModel.setValue(value);
        }
    }

    public static void forceSet(String key, Object value) {
        ValueModel valueModel = ValueModel.defaultValue(key);
        if (valueModel != null) {
            valueModel.setValue(value);
        }
        HotKeyStore.setValueDirectly(key, valueModel);
    }

    public static Object getValue(String key, KeyType keyType) {
        try {
            if (!HotKeyStore.inRule(key)) {
                return null;
            }
            Object userValue = null;
            ValueModel value = HotKeyStore.getValueSimple(key);
            if (value == null) {
                HotKeyPusher.push(key, keyType);
            } else {
                Object object;
                if (HotKeyStore.isNearExpire(value)) {
                    HotKeyPusher.push(key, keyType);
                }
                userValue = (object = value.getValue()) instanceof Integer && Constant.MAGIC_NUMBER == (Integer)object ? null : object;
            }
            KeyHandlerFactory.getCounter().collect(new KeyHotModel(key, value != null));
            return userValue;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getValue(String key) {
        return HotKeyStore.getValue(key, null);
    }

    static ValueModel getValueSimple(String key) {
        Object object = HotKeyStore.getCache(key).get(key);
        if (object == null) {
            return null;
        }
        return (ValueModel)object;
    }

    static void setValueDirectly(String key, Object value) {
        HotKeyStore.getCache(key).set(key, value);
    }

    public static void remove(String key) {
        HotKeyStore.getCache(key).delete(key);
        HotKeyPusher.remove(key);
    }

    static boolean isHot(String key) {
        return HotKeyStore.getValueSimple(key) != null;
    }

    private static LocalCache getCache(String key) {
        return CacheFactory.getNonNullCache(key);
    }

    private static boolean inRule(String key) {
        return CacheFactory.getCache(key) != null;
    }
}

