/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.client.core.key;

import com.valor.vod.hotkey.client.Context;
import com.valor.vod.hotkey.client.core.key.IKeyPusher;
import com.valor.vod.hotkey.client.core.worker.WorkerInfoHolder;
import com.valor.vod.hotkey.client.log.JdLogger;
import com.valor.vod.hotkey.common.model.HotKeyModel;
import com.valor.vod.hotkey.common.model.HotKeyMsg;
import com.valor.vod.hotkey.common.model.KeyCountModel;
import com.valor.vod.hotkey.common.model.typeenum.MessageType;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NettyKeyPusher
implements IKeyPusher {
    @Override
    public void send(String appName, List<HotKeyModel> list) {
        long now = System.currentTimeMillis();
        HashMap<Channel, List> map = new HashMap<Channel, List>();
        for (HotKeyModel model : list) {
            model.setCreateTime(now);
            Channel channel = WorkerInfoHolder.chooseChannel(model.getKey());
            if (channel == null) continue;
            List newList = map.computeIfAbsent(channel, k -> new ArrayList());
            newList.add(model);
        }
        for (Channel channel : map.keySet()) {
            try {
                List batch = (List)map.get(channel);
                HotKeyMsg hotKeyMsg = new HotKeyMsg(MessageType.REQUEST_NEW_KEY, Context.APP_NAME);
                hotKeyMsg.setHotKeyModels(batch);
                channel.writeAndFlush(hotKeyMsg).sync();
            }
            catch (Exception e) {
                try {
                    InetSocketAddress insocket = (InetSocketAddress)channel.remoteAddress();
                    JdLogger.error(this.getClass(), "flush error " + insocket.getAddress().getHostAddress());
                }
                catch (Exception ex) {
                    JdLogger.error(this.getClass(), "flush error");
                }
            }
        }
    }

    @Override
    public void sendCount(String appName, List<KeyCountModel> list) {
        long now = System.currentTimeMillis();
        HashMap<Channel, List> map = new HashMap<Channel, List>();
        for (KeyCountModel model : list) {
            model.setCreateTime(now);
            Channel channel = WorkerInfoHolder.chooseChannel(model.getRuleKey());
            if (channel == null) continue;
            List newList = map.computeIfAbsent(channel, k -> new ArrayList());
            newList.add(model);
        }
        for (Channel channel : map.keySet()) {
            try {
                List batch = (List)map.get(channel);
                HotKeyMsg hotKeyMsg = new HotKeyMsg(MessageType.REQUEST_HIT_COUNT, Context.APP_NAME);
                hotKeyMsg.setKeyCountModels(batch);
                channel.writeAndFlush(hotKeyMsg).sync();
            }
            catch (Exception e) {
                try {
                    InetSocketAddress insocket = (InetSocketAddress)channel.remoteAddress();
                    JdLogger.error(this.getClass(), "flush error " + insocket.getAddress().getHostAddress());
                }
                catch (Exception ex) {
                    JdLogger.error(this.getClass(), "flush error");
                }
            }
        }
    }
}

