/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.client.core.key;

import com.valor.vod.hotkey.client.Context;
import com.valor.vod.hotkey.client.core.key.IKeyCollector;
import com.valor.vod.hotkey.client.core.key.KeyHandlerFactory;
import com.valor.vod.hotkey.client.core.key.KeyHotModel;
import com.valor.vod.hotkey.common.model.HotKeyModel;
import com.valor.vod.hotkey.common.model.KeyCountModel;
import com.valor.vod.hotkey.common.tool.CollectionUtil;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PushSchedulerStarter {
    private ScheduledExecutorService scheduledExecutor;

    public PushSchedulerStarter(ScheduledExecutorService scheduled) {
        this.scheduledExecutor = scheduled;
    }

    public void startPusher(Long period) {
        if (period == null || period <= 0L) {
            period = 500L;
        }
        this.scheduledExecutor.scheduleAtFixedRate(() -> {
            IKeyCollector<HotKeyModel, HotKeyModel> collectHK = KeyHandlerFactory.getCollector();
            List<HotKeyModel> hotKeyModels = collectHK.lockAndGetResult();
            if (CollectionUtil.isNotEmpty(hotKeyModels)) {
                KeyHandlerFactory.getPusher().send(Context.APP_NAME, hotKeyModels);
                collectHK.finishOnce();
            }
        }, 0L, period, TimeUnit.MILLISECONDS);
    }

    public void startCountPusher(Integer period) {
        if (period == null || period <= 0) {
            period = 10;
        }
        this.scheduledExecutor.scheduleAtFixedRate(() -> {
            IKeyCollector<KeyHotModel, KeyCountModel> collectHK = KeyHandlerFactory.getCounter();
            List<KeyCountModel> keyCountModels = collectHK.lockAndGetResult();
            if (CollectionUtil.isNotEmpty(keyCountModels)) {
                KeyHandlerFactory.getPusher().sendCount(Context.APP_NAME, keyCountModels);
                collectHK.finishOnce();
            }
        }, 0L, period.intValue(), TimeUnit.SECONDS);
    }
}

