/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.client.core.key;

import com.valor.vod.hotkey.client.core.key.IKeyCollector;
import com.valor.vod.hotkey.client.core.key.KeyHotModel;
import com.valor.vod.hotkey.client.core.rule.KeyRuleHolder;
import com.valor.vod.hotkey.common.model.KeyCountModel;
import com.valor.vod.hotkey.common.tool.Constant;
import com.valor.vod.hotkey.common.tool.StrUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;

public class TurnCountCollector
implements IKeyCollector<KeyHotModel, KeyCountModel> {
    private ConcurrentHashMap<String, HitCount> HIT_MAP_0 = new ConcurrentHashMap(512);
    private ConcurrentHashMap<String, HitCount> HIT_MAP_1 = new ConcurrentHashMap(512);
    private static final String FORMAT = "yyyy-MM-dd HH:mm:ss";
    private AtomicLong atomicLong = new AtomicLong(0L);
    private static final int DATA_CONVERT_SWITCH_THRESHOLD = 5000;

    @Override
    public List<KeyCountModel> lockAndGetResult() {
        List<KeyCountModel> list;
        this.atomicLong.addAndGet(1L);
        if (this.atomicLong.get() % 2L == 0L) {
            list = this.get(this.HIT_MAP_1);
            this.HIT_MAP_1.clear();
        } else {
            list = this.get(this.HIT_MAP_0);
            this.HIT_MAP_0.clear();
        }
        return list;
    }

    private List<KeyCountModel> get(ConcurrentHashMap<String, HitCount> map) {
        if (map.size() > 5000) {
            return this.parallelConvert(map);
        }
        return this.syncConvert(map);
    }

    private List<KeyCountModel> parallelConvert(ConcurrentHashMap<String, HitCount> map) {
        return map.entrySet().parallelStream().map(entry -> {
            String key = (String)entry.getKey();
            HitCount hitCount = (HitCount)entry.getValue();
            KeyCountModel keyCountModel = new KeyCountModel();
            keyCountModel.setTotalHitCount((int)hitCount.totalHitCount.sum());
            keyCountModel.setRuleKey(key);
            keyCountModel.setHotHitCount((int)hitCount.hotHitCount.sum());
            return keyCountModel;
        }).collect(Collectors.toList());
    }

    private List<KeyCountModel> syncConvert(ConcurrentHashMap<String, HitCount> map) {
        ArrayList<KeyCountModel> list = new ArrayList<KeyCountModel>(map.size());
        for (Map.Entry<String, HitCount> entry : map.entrySet()) {
            String key = entry.getKey();
            HitCount hitCount = entry.getValue();
            KeyCountModel keyCountModel = new KeyCountModel();
            keyCountModel.setTotalHitCount((int)hitCount.totalHitCount.sum());
            keyCountModel.setRuleKey(key);
            keyCountModel.setHotHitCount((int)hitCount.hotHitCount.sum());
            list.add(keyCountModel);
        }
        return list;
    }

    @Override
    public void collect(KeyHotModel keyHotModel) {
        if (this.atomicLong.get() % 2L == 0L) {
            this.put(keyHotModel.getKey(), keyHotModel.isHot(), this.HIT_MAP_0);
        } else {
            this.put(keyHotModel.getKey(), keyHotModel.isHot(), this.HIT_MAP_1);
        }
    }

    @Override
    public void finishOnce() {
    }

    public void put(String key, boolean isHot, ConcurrentHashMap<String, HitCount> map) {
        String rule = KeyRuleHolder.rule(key);
        if (StrUtil.isEmpty(rule)) {
            return;
        }
        String nowTime = this.nowTime();
        String mapKey = rule + Constant.COUNT_DELIMITER + nowTime;
        HitCount hitCount = map.computeIfAbsent(mapKey, v -> new HitCount());
        if (isHot) {
            hitCount.hotHitCount.increment();
        }
        hitCount.totalHitCount.increment();
    }

    private String nowTime() {
        Date nowTime = new Date(System.currentTimeMillis());
        SimpleDateFormat sdFormatter = new SimpleDateFormat(FORMAT);
        return sdFormatter.format(nowTime);
    }

    private class HitCount {
        private LongAdder hotHitCount = new LongAdder();
        private LongAdder totalHitCount = new LongAdder();

        private HitCount() {
        }
    }
}

