/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.client.core.key;

import com.valor.vod.hotkey.client.core.key.IKeyCollector;
import com.valor.vod.hotkey.common.model.HotKeyModel;
import com.valor.vod.hotkey.common.tool.CollectionUtil;
import com.valor.vod.hotkey.common.tool.StrUtil;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class TurnKeyCollector
implements IKeyCollector<HotKeyModel, HotKeyModel> {
    private ConcurrentHashMap<String, HotKeyModel> map0 = new ConcurrentHashMap();
    private ConcurrentHashMap<String, HotKeyModel> map1 = new ConcurrentHashMap();
    private AtomicLong atomicLong = new AtomicLong(0L);

    @Override
    public List<HotKeyModel> lockAndGetResult() {
        List<HotKeyModel> list;
        this.atomicLong.addAndGet(1L);
        if (this.atomicLong.get() % 2L == 0L) {
            list = this.get(this.map1);
            this.map1.clear();
        } else {
            list = this.get(this.map0);
            this.map0.clear();
        }
        return list;
    }

    private List<HotKeyModel> get(ConcurrentHashMap<String, HotKeyModel> map) {
        return CollectionUtil.list(false, map.values());
    }

    @Override
    public void collect(HotKeyModel hotKeyModel) {
        String key = hotKeyModel.getKey();
        if (StrUtil.isEmpty(key)) {
            return;
        }
        if (this.atomicLong.get() % 2L == 0L) {
            HotKeyModel model = this.map0.putIfAbsent(key, hotKeyModel);
            if (model != null) {
                model.add(hotKeyModel.getCount());
            }
        } else {
            HotKeyModel model = this.map1.putIfAbsent(key, hotKeyModel);
            if (model != null) {
                model.add(hotKeyModel.getCount());
            }
        }
    }

    @Override
    public void finishOnce() {
    }
}

