/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.client.core.rule;

import com.google.common.eventbus.Subscribe;
import com.valor.vod.hotkey.client.cache.CacheFactory;
import com.valor.vod.hotkey.client.cache.LocalCache;
import com.valor.vod.hotkey.client.core.rule.KeyRuleInfoChangeEvent;
import com.valor.vod.hotkey.client.log.JdLogger;
import com.valor.vod.hotkey.common.rule.KeyRule;
import com.valor.vod.hotkey.common.tool.CollectionUtil;
import com.valor.vod.hotkey.common.tool.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class KeyRuleHolder {
    private static final ConcurrentHashMap<Integer, LocalCache> RULE_CACHE_MAP = new ConcurrentHashMap();
    private static final List<KeyRule> KEY_RULES = new ArrayList<KeyRule>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putRules(List<KeyRule> keyRules) {
        List<KeyRule> list = KEY_RULES;
        synchronized (list) {
            if (CollectionUtil.isEmpty(keyRules)) {
                KEY_RULES.clear();
                RULE_CACHE_MAP.clear();
                return;
            }
            KEY_RULES.clear();
            KEY_RULES.addAll(keyRules);
            Set durationSet = keyRules.stream().map(KeyRule::getDuration).collect(Collectors.toSet());
            for (Integer duration : RULE_CACHE_MAP.keySet()) {
                if (durationSet.contains(duration)) continue;
                RULE_CACHE_MAP.remove(duration);
            }
            for (KeyRule keyRule : keyRules) {
                int duration = keyRule.getDuration();
                if (RULE_CACHE_MAP.get(duration) != null) continue;
                LocalCache cache = CacheFactory.build(duration);
                RULE_CACHE_MAP.put(duration, cache);
            }
        }
    }

    public static LocalCache findByKey(String key) {
        if (StrUtil.isEmpty(key)) {
            return null;
        }
        KeyRule keyRule = KeyRuleHolder.findRule(key);
        if (keyRule == null) {
            return null;
        }
        return RULE_CACHE_MAP.get(keyRule.getDuration());
    }

    public static String rule(String key) {
        KeyRule keyRule = KeyRuleHolder.findRule(key);
        if (keyRule != null) {
            return keyRule.getKey();
        }
        return "";
    }

    public static int duration(String key) {
        KeyRule keyRule = KeyRuleHolder.findRule(key);
        if (keyRule != null) {
            return keyRule.getDuration();
        }
        return 0;
    }

    private static KeyRule findRule(String key) {
        KeyRule prefix = null;
        KeyRule common = null;
        for (KeyRule keyRule : KEY_RULES) {
            if (key.equals(keyRule.getKey())) {
                return keyRule;
            }
            if (keyRule.isPrefix() && key.startsWith(keyRule.getKey())) {
                prefix = keyRule;
            }
            if (!"*".equals(keyRule.getKey())) continue;
            common = keyRule;
        }
        if (prefix != null) {
            return prefix;
        }
        return common;
    }

    public static boolean isKeyInRule(String key) {
        if (StrUtil.isEmpty(key)) {
            return false;
        }
        for (KeyRule keyRule : KEY_RULES) {
            if (!"*".equals(keyRule.getKey()) && !key.equals(keyRule.getKey()) && (!keyRule.isPrefix() || !key.startsWith(keyRule.getKey()))) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void ruleChange(KeyRuleInfoChangeEvent event) {
        JdLogger.info(this.getClass(), "new rules info is :" + event.getKeyRules());
        List<KeyRule> ruleList = event.getKeyRules();
        if (ruleList == null) {
            return;
        }
        KeyRuleHolder.putRules(ruleList);
    }
}

