/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.client.netty;

import com.valor.vod.hotkey.client.Context;
import com.valor.vod.hotkey.client.callback.ReceiveNewKeyEvent;
import com.valor.vod.hotkey.client.core.eventbus.EventBusCenter;
import com.valor.vod.hotkey.client.log.JdLogger;
import com.valor.vod.hotkey.client.netty.event.ChannelInactiveEvent;
import com.valor.vod.hotkey.common.model.HotKeyModel;
import com.valor.vod.hotkey.common.model.HotKeyMsg;
import com.valor.vod.hotkey.common.model.typeenum.MessageType;
import com.valor.vod.hotkey.common.tool.CollectionUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;

@ChannelHandler.Sharable
public class NettyClientHandler
extends SimpleChannelInboundHandler<HotKeyMsg> {
    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent idleStateEvent;
        if (evt instanceof IdleStateEvent && (idleStateEvent = (IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
            ctx.writeAndFlush(new HotKeyMsg(MessageType.PING, Context.APP_NAME));
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        JdLogger.info(this.getClass(), "channelActive:" + ctx.name());
        ctx.writeAndFlush(new HotKeyMsg(MessageType.APP_NAME, Context.APP_NAME));
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.notifyWorkerChange(ctx.channel());
    }

    private void notifyWorkerChange(Channel channel) {
        EventBusCenter.getInstance().post(new ChannelInactiveEvent(channel));
    }

    @Override
    protected void channelRead0(ChannelHandlerContext channelHandlerContext, HotKeyMsg msg) {
        if (MessageType.PONG == msg.getMessageType()) {
            JdLogger.info(this.getClass(), "heart beat");
            return;
        }
        if (MessageType.RESPONSE_NEW_KEY == msg.getMessageType()) {
            JdLogger.info(this.getClass(), "receive new key : " + msg);
            if (CollectionUtil.isEmpty(msg.getHotKeyModels())) {
                return;
            }
            for (HotKeyModel model : msg.getHotKeyModels()) {
                EventBusCenter.getInstance().post(new ReceiveNewKeyEvent(model));
            }
        }
    }
}

