/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.common.configcenter;

import com.valor.vod.hotkey.common.configcenter.IConfigCenter;
import com.valor.vod.hotkey.common.configcenter.INotifyListener;
import com.valor.vod.hotkey.common.configcenter.model.DataEvent;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigCenter
implements IConfigCenter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfigCenter.class);
    private final ConcurrentMap<SubscribeKey, Set<INotifyListener>> listenerMap = new ConcurrentHashMap<SubscribeKey, Set<INotifyListener>>();

    @Override
    public void subscribe(String key, INotifyListener listener) {
        SubscribeKey sk = new SubscribeKey(key, false);
        this.addNotifyListener(sk, listener);
    }

    @Override
    public void subscribePrefix(String key, INotifyListener listener) {
        SubscribeKey sk = new SubscribeKey(key, true);
        this.addNotifyListener(sk, listener);
    }

    @Override
    public void unsubscribe(String key, INotifyListener listener) {
        SubscribeKey sk = new SubscribeKey(key, false);
        this.removeNotifyListener(sk, listener);
    }

    private void addNotifyListener(SubscribeKey sk, INotifyListener listener) {
        this.listenerMap.compute(sk, (k, listeners) -> {
            if (listeners == null) {
                listeners = new CopyOnWriteArraySet<INotifyListener>();
                listeners.add(listener);
                this.doSubscribe(sk);
            } else {
                listeners.add(listener);
            }
            return listeners;
        });
    }

    private void removeNotifyListener(SubscribeKey sk, INotifyListener listener) {
        this.listenerMap.computeIfPresent(sk, (k, listeners) -> {
            if (listeners.remove(listener) && listeners.isEmpty()) {
                this.doUnsubscribe(sk);
            }
            return listeners;
        });
    }

    protected void doSubscribe(SubscribeKey sk) {
    }

    protected void doUnsubscribe(SubscribeKey sk) {
    }

    protected void fireDataChange(DataEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("Fire data change" + event);
        }
        this.listenerMap.forEach((k, v) -> {
            boolean notify;
            String path = event.getSource().toString();
            boolean bl = notify = Objects.equals(path, k.getKey()) || k.isPrefix() && path.startsWith(k.getKey());
            if (notify) {
                for (INotifyListener listener : v) {
                    try {
                        listener.notifyDataChange(event);
                    }
                    catch (Exception e) {
                        logger.error("Notify error.", e);
                    }
                }
            }
        });
    }

    public static class SubscribeKey
    implements Serializable {
        private String key;
        private boolean prefix;

        public SubscribeKey(String key, boolean prefix) {
            this.key = key;
            this.prefix = prefix;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isPrefix() {
            return this.prefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubscribeKey that = (SubscribeKey)o;
            return this.prefix == that.prefix && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.prefix);
        }
    }
}

