/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.hotkey.common.tool;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class ClassUtils {
    public static final char JVM_VOID = 'V';
    public static final char JVM_BOOLEAN = 'Z';
    public static final char JVM_BYTE = 'B';
    public static final char JVM_CHAR = 'C';
    public static final char JVM_DOUBLE = 'D';
    public static final char JVM_FLOAT = 'F';
    public static final char JVM_INT = 'I';
    public static final char JVM_LONG = 'J';
    public static final char JVM_SHORT = 'S';
    private static final Map<Class<?>, Object> PRIMITIVE_DEFAULT_VALUE = new HashMap();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER = new HashMap();

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = clazz.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static Class<?> forName(String name) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        try {
            return clazz.getConstructor(parameterTypes).newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(String name, Object ... args) {
        return (T)ClassUtils.newInstance(ClassUtils.forName(name), args);
    }

    public static <T> T castTo(String s2, Class<T> clazz) {
        if (s2 == null) {
            return ClassUtils.getDefaultValue(clazz);
        }
        try {
            Object obj = null;
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                obj = Byte.parseByte(s2);
            } else if (clazz == Character.TYPE || clazz == Character.class) {
                obj = Character.valueOf((char)Integer.parseInt(s2));
            } else if (clazz == Short.TYPE || clazz == Short.class) {
                obj = Short.valueOf(s2);
            } else if (clazz == Integer.TYPE || clazz == Integer.class) {
                obj = Integer.valueOf(s2);
            } else if (clazz == Long.TYPE || clazz == Long.class) {
                obj = Long.valueOf(s2);
            } else if (clazz == Float.TYPE || clazz == Float.class) {
                obj = Float.valueOf(s2);
            } else if (clazz == Double.TYPE || clazz == Double.class) {
                obj = Double.valueOf(s2);
            } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                obj = Boolean.valueOf(s2);
            } else if (CharSequence.class.isAssignableFrom(clazz)) {
                obj = s2;
            }
            if (obj != null) {
                return (T)obj;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ClassUtils.getDefaultValue(clazz);
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        for (Class<?> c : PRIMITIVE_WRAPPER.values()) {
            if (c != clazz) continue;
            return true;
        }
        return false;
    }

    public static <T> T castTo(Object obj, Class<T> toClass) {
        if (obj == null) {
            return ClassUtils.getDefaultValue(toClass);
        }
        Class<?> fromClass = obj.getClass();
        if (fromClass.getName().equals(toClass.getName())) {
            return (T)obj;
        }
        if (toClass.isAssignableFrom(fromClass)) {
            return (T)obj;
        }
        if (fromClass == String.class) {
            return ClassUtils.castTo((String)obj, toClass);
        }
        if (Number.class.isAssignableFrom(fromClass) && (Number.class.isAssignableFrom(toClass) || toClass.isPrimitive())) {
            return ClassUtils.castTo(obj.toString(), toClass);
        }
        if (fromClass.isArray() && toClass.isArray()) {
            int len = Array.getLength(obj);
            Class<?> toComponentType = toClass.getComponentType();
            Object newArr = Array.newInstance(toComponentType, len);
            for (int i = 0; i < len; ++i) {
                Array.set(newArr, i, ClassUtils.castTo(Array.get(obj, i), toComponentType));
            }
            return (T)newArr;
        }
        return ClassUtils.getDefaultValue(toClass);
    }

    public static <T> T getDefaultValue(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            return (T)PRIMITIVE_DEFAULT_VALUE.get(clazz);
        }
        return null;
    }

    public static <A extends Annotation> A getAnnotation(Class clazz, Class<A> annotationClass) {
        Class<?>[] interfaces;
        if (clazz == Object.class) {
            return null;
        }
        A res = clazz.getAnnotation(annotationClass);
        if (res != null) {
            return res;
        }
        res = ClassUtils.getAnnotation(clazz.getSuperclass(), annotationClass);
        if (res != null) {
            return res;
        }
        for (Class<?> ifac : interfaces = clazz.getInterfaces()) {
            res = ClassUtils.getAnnotation(ifac, annotationClass);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationClass) {
        if (method == null) {
            return null;
        }
        return method.getAnnotation(annotationClass);
    }

    public static <A> A getAnnotation(Annotation[] annotations, Class<A> annotationClass) {
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            return (A)annotation;
        }
        return null;
    }

    public static String getDesc(Class<?>[] cs) {
        if (cs.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(64);
        for (Class<?> c : cs) {
            sb.append(ClassUtils.getDesc(c));
        }
        return sb.toString();
    }

    public static String getDesc(Class<?> c) {
        StringBuilder ret = new StringBuilder();
        while (c.isArray()) {
            ret.append('[');
            c = c.getComponentType();
        }
        if (c.isPrimitive()) {
            String t2 = c.getName();
            if ("void".equals(t2)) {
                ret.append('V');
            } else if ("boolean".equals(t2)) {
                ret.append('Z');
            } else if ("byte".equals(t2)) {
                ret.append('B');
            } else if ("char".equals(t2)) {
                ret.append('C');
            } else if ("double".equals(t2)) {
                ret.append('D');
            } else if ("float".equals(t2)) {
                ret.append('F');
            } else if ("int".equals(t2)) {
                ret.append('I');
            } else if ("long".equals(t2)) {
                ret.append('J');
            } else if ("short".equals(t2)) {
                ret.append('S');
            }
        } else {
            ret.append('L');
            ret.append(c.getName().replace('.', '/'));
            ret.append(';');
        }
        return ret.toString();
    }

    public static String getDesc(Method m4) {
        StringBuilder ret = new StringBuilder(m4.getName()).append('(');
        Class<?>[] parameterTypes = m4.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ret.append(ClassUtils.getDesc(parameterTypes[i]));
        }
        ret.append(')').append(ClassUtils.getDesc(m4.getReturnType()));
        return ret.toString();
    }

    static {
        PRIMITIVE_DEFAULT_VALUE.put(Boolean.TYPE, Boolean.FALSE);
        PRIMITIVE_DEFAULT_VALUE.put(Byte.TYPE, (byte)0);
        PRIMITIVE_DEFAULT_VALUE.put(Character.TYPE, Character.valueOf('\u0000'));
        PRIMITIVE_DEFAULT_VALUE.put(Short.TYPE, (short)0);
        PRIMITIVE_DEFAULT_VALUE.put(Integer.TYPE, 0);
        PRIMITIVE_DEFAULT_VALUE.put(Long.TYPE, 0L);
        PRIMITIVE_DEFAULT_VALUE.put(Float.TYPE, Float.valueOf(0.0f));
        PRIMITIVE_DEFAULT_VALUE.put(Double.TYPE, 0.0);
        PRIMITIVE_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_WRAPPER.put(Character.TYPE, Character.class);
        PRIMITIVE_WRAPPER.put(Short.TYPE, Short.class);
        PRIMITIVE_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_WRAPPER.put(Double.TYPE, Double.class);
    }
}

